/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class TestCommand
extends AbstractFileSystemCommand {
    private static final Option DIR_OPTION = Option.builder((String)"d").required(false).hasArg(false).desc("test whether path is a directory.").build();
    private static final Option FILE_OPTION = Option.builder((String)"f").required(false).hasArg(false).desc("test whether path is a file.").build();
    private static final Option PATH_EXIST_OPTION = Option.builder((String)"e").required(false).hasArg(false).desc("test whether path exists.").build();
    private static final Option DIR_NOT_EMPTY_OPTION = Option.builder((String)"s").required(false).hasArg(false).desc("test whether path is not empty.").build();
    private static final Option FILE_ZERO_LENGTH_OPTION = Option.builder((String)"z").required(false).hasArg(false).desc("test whether file is zero length.").build();

    public TestCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "test";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public Options getOptions() {
        return new Options().addOption(DIR_OPTION).addOption(FILE_OPTION).addOption(PATH_EXIST_OPTION).addOption(DIR_NOT_EMPTY_OPTION).addOption(FILE_ZERO_LENGTH_OPTION);
    }

    private boolean isDir(URIStatus status) {
        return status.isFolder();
    }

    private boolean isFile(URIStatus status) {
        return !status.isFolder();
    }

    private boolean isNonEmptyDir(URIStatus status) {
        return status.isFolder() && status.getLength() > 0L;
    }

    private boolean isZeroLengthFile(URIStatus status) {
        return !status.isFolder() && status.getLength() == 0L;
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        if (cl.getOptions().length > 1) {
            return -1;
        }
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        try {
            URIStatus status = this.mFileSystem.getStatus(path);
            boolean testResult = false;
            if (cl.hasOption("d")) {
                if (this.isDir(status)) {
                    testResult = true;
                }
            } else if (cl.hasOption("f")) {
                if (this.isFile(status)) {
                    testResult = true;
                }
            } else if (cl.hasOption("e")) {
                testResult = true;
            } else if (cl.hasOption("s")) {
                if (this.isNonEmptyDir(status)) {
                    testResult = true;
                }
            } else if (cl.hasOption("z")) {
                if (this.isZeroLengthFile(status)) {
                    testResult = true;
                }
            } else {
                return -1;
            }
            return testResult ? 0 : 1;
        }
        catch (FileNotFoundException e) {
            return 1;
        }
        catch (IOException e) {
            return 2;
        }
        catch (AlluxioException e) {
            return 3;
        }
    }

    public String getUsage() {
        return "test [-d|-f|-e|-s|-z] <path>";
    }

    public String getDescription() {
        return "Test a property of a path, returning 0 if the property is true, or 1 otherwise.";
    }
}

