/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;

public class StopSyncCommand
extends AbstractFileSystemCommand {
    public StopSyncCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "stopSync";
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        this.mFileSystem.stopSync(path);
        System.out.println("Stopped automatic syncing of '" + path + "'.");
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "stopSync <path>";
    }

    public String getDescription() {
        return "Stops the automatic syncing process of the specified path). ";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

