/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.resource.CloseableResource;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class StatCommand
extends AbstractFileSystemCommand {
    public static final Option FORMAT_OPTION = Option.builder((String)"f").required(false).hasArg().desc("format").build();
    public static final Option FILE_ID_OPTION = Option.builder().longOpt("file-id").required(false).desc("specify a file by file-id").build();
    private static final String FORMAT_REGEX = "%([biguyzNY])";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%([biguyzNY])");

    public StatCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "stat";
    }

    public Options getOptions() {
        return new Options().addOption(FORMAT_OPTION).addOption(FILE_ID_OPTION);
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        URIStatus status = this.mFileSystem.getStatus(path);
        if (cl.hasOption(FORMAT_OPTION.getOpt())) {
            System.out.println(this.formatOutput(cl, status));
        } else if (status.isFolder()) {
            System.out.println(path + " is a directory path.");
            System.out.println(status);
        } else {
            System.out.println(path + " is a file path.");
            System.out.println(status);
            BlockStoreClient blockStore = BlockStoreClient.create((FileSystemContext)this.mFsContext);
            List blockIds = status.getBlockIds();
            if (blockIds.isEmpty()) {
                System.out.println("This file does not contain any blocks.");
            } else {
                System.out.println("Containing the following blocks: ");
                Iterator iterator = blockIds.iterator();
                while (iterator.hasNext()) {
                    long blockId = (Long)iterator.next();
                    System.out.println(blockStore.getInfo(blockId));
                }
            }
        }
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        AlluxioURI path;
        String[] args = cl.getArgs();
        if (cl.hasOption(FILE_ID_OPTION.getLongOpt())) {
            long fileId = Long.parseLong(args[0]);
            try (CloseableResource client = this.mFsContext.acquireMasterClientResource();){
                path = new AlluxioURI(((FileSystemMasterClient)client.get()).getFilePath(fileId));
            }
            System.out.println("The specified file ID " + fileId + " is " + path);
        } else {
            path = new AlluxioURI(args[0]);
        }
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "stat [-f <format>] <path> or stat [-f <format>] --file-id <file-id>";
    }

    public String getDescription() {
        return String.join((CharSequence)"\n", Arrays.asList("Displays info for the specified file or directory.", "Specify --file-id to treat the first positional argument as a file ID.", "Specify -f to display info in given format:", "   \"%N\": name of the file;", "   \"%z\": size of file in bytes;", "   \"%u\": owner;", "   \"%g\": group name of owner;", "   \"%i\": file id of the file;", "   \"%y\": modification time in UTC in 'yyyy-MM-dd HH:mm:ss' format;", "   \"%Y\": modification time as Unix timestamp in milliseconds;", "   \"%b\": Number of blocks allocated for file"));
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    private String formatOutput(CommandLine cl, URIStatus status) {
        String format = cl.getOptionValue('f');
        int formatLen = format.length();
        StringBuilder output = new StringBuilder();
        Matcher m = FORMAT_PATTERN.matcher(format);
        int i = 0;
        while (i < formatLen && m.find(i)) {
            if (m.start() != i) {
                output.append(format.substring(i, m.start()));
            }
            output.append(this.getField(m, status));
            i = m.end();
        }
        if (i < formatLen) {
            output.append(format.substring(i));
        }
        return output.toString();
    }

    private String getField(Matcher m, URIStatus status) {
        char formatSpecifier = m.group(1).charAt(0);
        String resp = null;
        switch (formatSpecifier) {
            case 'b': {
                resp = status.isFolder() ? "NA" : String.valueOf(status.getFileBlockInfos().size());
                break;
            }
            case 'g': {
                resp = status.getGroup();
                break;
            }
            case 'i': {
                resp = String.valueOf(status.getFileId());
                break;
            }
            case 'u': {
                resp = status.getOwner();
                break;
            }
            case 'y': {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                resp = sdf.format(new Date(status.getLastModificationTimeMs()));
                break;
            }
            case 'z': {
                resp = status.isFolder() ? "NA" : String.valueOf(status.getLength());
                break;
            }
            case 'N': {
                resp = status.getName();
                break;
            }
            case 'Y': {
                resp = String.valueOf(status.getLastModificationTimeMs());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown format specifier %c", Character.valueOf(formatSpecifier)));
            }
        }
        return resp;
    }
}

