/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class StartSyncCommand
extends AbstractFileSystemCommand {
    public StartSyncCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "startSync";
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) {
        System.out.println("Starting a full sync of '" + path + "'. You can check the status of the sync using getSyncPathList cmd");
        try {
            this.mFileSystem.startSync(path);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            System.out.println("Failed to start automatic syncing of '" + path + "'.");
            throw new RuntimeException(e);
        }
        System.out.println("Started automatic syncing of '" + path + "'.");
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "startSync <path>";
    }

    public String getDescription() {
        return "Starts the automatic syncing process of the specified path). ";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

