/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.security.authorization.AclEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class SetFaclCommand
extends AbstractFileSystemCommand {
    private static final Option RECURSIVE_OPTION = Option.builder((String)"R").required(false).hasArg(false).desc("Apply to all files and directories recursively").build();
    private static final Option SET_OPTION = Option.builder().longOpt("set").required(false).hasArg().desc("Fully replace the ACL while discarding existing entries. New ACL must be a comma separated list of entries, and must include user, group, and other for compatibility with permission bits.").build();
    private static final Option MODIFY_OPTION = Option.builder((String)"m").required(false).hasArg().desc("Modify the ACL by adding/overwriting new entries.").build();
    private static final Option REMOVE_OPTION = Option.builder((String)"x").required(false).hasArg().desc("Removes specified ACL entries.").build();
    private static final Option REMOVE_ALL_OPTION = Option.builder((String)"b").required(false).hasArg(false).desc("Removes all of the ACL entries, except for the base entries.").build();
    private static final Option DEFAULT_OPTION = Option.builder((String)"d").required(false).hasArg(false).desc("Operations apply to the default ACL").build();
    private static final Option REMOVE_DEFAULT_OPTION = Option.builder((String)"k").required(false).hasArg(false).desc("Remove the default acl. If no default acl exists, no warnings are given.").build();

    public SetFaclCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "setfacl";
    }

    public Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION).addOption(SET_OPTION).addOption(MODIFY_OPTION).addOption(REMOVE_OPTION).addOption(REMOVE_ALL_OPTION).addOption(DEFAULT_OPTION).addOption(REMOVE_DEFAULT_OPTION);
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        String aclList;
        SetAclPOptions options = SetAclPOptions.newBuilder().setRecursive(cl.hasOption(RECURSIVE_OPTION.getOpt())).build();
        List entries = Collections.emptyList();
        SetAclAction action = SetAclAction.REPLACE;
        ArrayList<String> specifiedActions = new ArrayList<String>(1);
        if (cl.hasOption(SET_OPTION.getLongOpt())) {
            specifiedActions.add(SET_OPTION.getLongOpt());
            action = SetAclAction.REPLACE;
            aclList = cl.getOptionValue(SET_OPTION.getLongOpt());
            entries = cl.hasOption(DEFAULT_OPTION.getOpt()) ? Arrays.stream(aclList.split(",")).map(AclEntry::toDefault).map(AclEntry::fromCliString).collect(Collectors.toList()) : Arrays.stream(aclList.split(",")).map(AclEntry::fromCliString).collect(Collectors.toList());
        }
        if (cl.hasOption(MODIFY_OPTION.getOpt())) {
            specifiedActions.add(MODIFY_OPTION.getOpt());
            action = SetAclAction.MODIFY;
            aclList = cl.getOptionValue(MODIFY_OPTION.getOpt());
            entries = cl.hasOption(DEFAULT_OPTION.getOpt()) ? Arrays.stream(aclList.split(",")).map(AclEntry::toDefault).map(AclEntry::fromCliString).collect(Collectors.toList()) : Arrays.stream(aclList.split(",")).map(AclEntry::fromCliString).collect(Collectors.toList());
        }
        if (cl.hasOption(REMOVE_OPTION.getOpt())) {
            specifiedActions.add(REMOVE_OPTION.getOpt());
            action = SetAclAction.REMOVE;
            aclList = cl.getOptionValue(REMOVE_OPTION.getOpt());
            entries = cl.hasOption(DEFAULT_OPTION.getOpt()) ? Arrays.stream(aclList.split(",")).map(AclEntry::toDefault).map(AclEntry::fromCliStringWithoutPermissions).collect(Collectors.toList()) : Arrays.stream(aclList.split(",")).map(AclEntry::fromCliStringWithoutPermissions).collect(Collectors.toList());
        }
        if (cl.hasOption(REMOVE_ALL_OPTION.getOpt())) {
            specifiedActions.add(REMOVE_ALL_OPTION.getOpt());
            action = SetAclAction.REMOVE_ALL;
        }
        if (cl.hasOption(REMOVE_DEFAULT_OPTION.getOpt())) {
            specifiedActions.add(REMOVE_DEFAULT_OPTION.getOpt());
            action = SetAclAction.REMOVE_DEFAULT;
        }
        if (specifiedActions.isEmpty()) {
            throw new IllegalArgumentException("No actions specified.");
        }
        if (specifiedActions.size() > 1) {
            throw new IllegalArgumentException("Only 1 action can be specified: " + String.join((CharSequence)", ", specifiedActions));
        }
        this.mFileSystem.setAcl(path, action, entries, options);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "setfacl [-d] [-R] [--set | -m | -x <acl_entries> <path>] | [-b | -k <path>]";
    }

    public String getDescription() {
        return "Sets the access control list (ACL) for a path.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }
}

