/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.fs.command.FileSystemCommandUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class PinCommand
extends AbstractFileSystemCommand {
    public PinCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "pin";
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        List<String> pinnedMediumTypes = Arrays.asList(Arrays.copyOfRange(args, 1, args.length));
        List availableMediumList = this.mFsContext.getPathConf(path).getList(PropertyKey.MASTER_TIERED_STORE_GLOBAL_MEDIUMTYPE);
        ArrayList<String> invalidMediumType = new ArrayList<String>();
        ArrayList<String> validMediumType = new ArrayList<String>();
        for (String mediumType : pinnedMediumTypes) {
            if (availableMediumList.contains(mediumType)) {
                validMediumType.add(mediumType);
                continue;
            }
            invalidMediumType.add(mediumType);
        }
        if (!invalidMediumType.isEmpty()) {
            throw new IllegalArgumentException("Invalid medium to pin the file. " + String.join((CharSequence)",", invalidMediumType) + " are invalid. " + String.join((CharSequence)",", validMediumType) + " are valid medium types");
        }
        FileSystemCommandUtils.setPinned(this.mFileSystem, path, true, pinnedMediumTypes);
        System.out.println("File '" + path + "' was successfully pinned.");
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "pin <path> media1 media2 media3 ...";
    }

    public String getDescription() {
        return "Pins the given file or directory in memory (works recursively for directories). Pinned files are never evicted from memory, unless TTL is set.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

