/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.CreateDirectoryPOptions;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class MkdirCommand
extends AbstractFileSystemCommand {
    public MkdirCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "mkdir";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args;
        for (String path : args = cl.getArgs()) {
            AlluxioURI inputPath = new AlluxioURI(path);
            CreateDirectoryPOptions options = CreateDirectoryPOptions.newBuilder().setRecursive(true).build();
            this.mFileSystem.createDirectory(inputPath, options);
            System.out.println("Successfully created directory " + inputPath);
        }
        return 0;
    }

    public String getUsage() {
        return "mkdir <path1> [path2] ... [pathn]";
    }

    public String getDescription() {
        return "Creates the specified directories, including any parent directories that are required.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

