/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.ListStatusPOptions;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public class LoadMetadataCommand
extends AbstractFileSystemCommand {
    private static final Option RECURSIVE_OPTION = Option.builder((String)"R").required(false).hasArg(false).desc("load metadata subdirectories recursively").build();
    private static final Option FORCE_OPTION = Option.builder((String)"F").required(false).hasArg(false).desc("update the metadata of the existing sub file forcibly").build();

    public LoadMetadataCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "loadMetadata";
    }

    public Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION).addOption(FORCE_OPTION);
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        this.loadMetadata(plainPath, cl.hasOption(RECURSIVE_OPTION.getOpt()), cl.hasOption(FORCE_OPTION.getOpt()));
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    private void loadMetadata(AlluxioURI path, boolean recursive, boolean force) throws IOException {
        try {
            ListStatusPOptions options = force ? ListStatusPOptions.newBuilder().setRecursive(recursive).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build()).build() : ListStatusPOptions.newBuilder().setRecursive(recursive).build();
            this.mFileSystem.loadMetadata(path, options);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getUsage() {
        return "loadMetadata [-R] [-F] <path>";
    }

    public String getDescription() {
        return "Loads metadata for the given Alluxio path from the under file system.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

