/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

@ThreadSafe
public final class HelpCommand
extends AbstractFileSystemCommand {
    private static final HelpFormatter HELP_FORMATTER = new HelpFormatter();

    public static void printCommandInfo(Command command, PrintWriter pw) {
        String description = String.format("%s: %s", command.getCommandName(), command.getDescription());
        int width = 80;
        try (Terminal terminal = TerminalBuilder.terminal();){
            width = terminal.getWidth();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (width == 0) {
            width = 80;
        }
        HELP_FORMATTER.printWrapped(pw, width, description);
        HELP_FORMATTER.printUsage(pw, width, command.getUsage());
        if (command.getOptions().getOptions().size() > 0) {
            HELP_FORMATTER.printOptions(pw, width, command.getOptions(), HELP_FORMATTER.getLeftPadding(), HELP_FORMATTER.getDescPadding());
        }
    }

    public HelpCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "help";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        Map<String, Command> commands = FileSystemShellUtils.loadCommands(this.mFsContext);
        try (PrintWriter pw = new PrintWriter(System.out);){
            if (args.length == 0) {
                TreeSet<String> sortedCmds = new TreeSet<String>(commands.keySet());
                for (String commandName : sortedCmds) {
                    Command command = commands.get(commandName);
                    HelpCommand.printCommandInfo(command, pw);
                    pw.println();
                }
            } else if (commands.containsKey(args[0])) {
                Command command = commands.get(args[0]);
                HelpCommand.printCommandInfo(command, pw);
            } else {
                pw.println(args[0] + " is an unknown command.");
                int n = -1;
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public String getUsage() {
        return "help [<command>]";
    }

    public String getDescription() {
        return "Prints help message for the given command. If there isn't given command, prints help messages for all supported commands.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoMoreThan((Command)this, (CommandLine)cl, (int)1);
    }
}

