/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class GetUsedBytesCommand
extends AbstractFileSystemCommand {
    public GetUsedBytesCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "getUsedBytes";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }

    public int run(CommandLine cl) throws IOException {
        BlockStoreClient blockStore = BlockStoreClient.create((FileSystemContext)this.mFsContext);
        long usedBytes = blockStore.getUsedBytes();
        System.out.println("Used Bytes: " + usedBytes);
        return 0;
    }

    public String getUsage() {
        return "getUsedBytes";
    }

    public String getDescription() {
        return "Gets number of bytes used in the Alluxio file system.";
    }
}

