/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class GetFaclCommand
extends AbstractFileSystemCommand {
    public GetFaclCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "getfacl";
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        URIStatus status = this.mFileSystem.getStatus(path);
        System.out.println("# file: " + status.getPath());
        System.out.println("# owner: " + status.getOwner());
        System.out.println("# group: " + status.getGroup());
        for (String entry : status.getAcl().toStringEntries()) {
            System.out.println(entry);
        }
        List defaultAclEntries = status.getDefaultAcl().toStringEntries();
        for (String entry : defaultAclEntries) {
            System.out.println(entry);
        }
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "getfacl <path>";
    }

    public String getDescription() {
        return "Displays the access control lists (ACLs) for a path.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }
}

