/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class GetCapacityBytesCommand
extends AbstractFileSystemCommand {
    public GetCapacityBytesCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "getCapacityBytes";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }

    public int run(CommandLine cl) throws IOException {
        BlockStoreClient blockStoreClient = BlockStoreClient.create((FileSystemContext)this.mFsContext);
        long capacityBytes = blockStoreClient.getCapacityBytes();
        System.out.println("Capacity Bytes: " + capacityBytes);
        return 0;
    }

    public String getUsage() {
        return "getCapacityBytes";
    }

    public String getDescription() {
        return "Gets the capacity of the Alluxio file system.";
    }
}

