/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FileSystemCommandUtils {
    private FileSystemCommandUtils() {
    }

    public static void setTtl(FileSystem fs, AlluxioURI path, long ttlMs, TtlAction ttlAction) throws AlluxioException, IOException {
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setRecursive(true).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttlMs).setTtlAction(ttlAction).build()).build();
        fs.setAttribute(path, options);
    }

    public static void setPinned(FileSystem fs, AlluxioURI path, boolean pinned, List<String> mediumTypes) throws AlluxioException, IOException {
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setPinned(pinned).addAllPinnedMedia(mediumTypes).build();
        fs.setAttribute(path, options);
    }
}

