/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.cli.fs.command.AbstractDistributedJobCommand;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.job.CmdConfig;
import alluxio.job.cmd.migrate.MigrateCliConfig;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public class DistributedCpCommand
extends AbstractDistributedJobCommand {
    private static final String DEFAULT_FAILURE_FILE_PATH = "./logs/user/distributedCp_%s_failures.csv";
    private WriteType mWriteType;
    private static final Option ACTIVE_JOB_COUNT_OPTION = Option.builder().longOpt("active-jobs").required(false).hasArg(true).numberOfArgs(1).type(Number.class).argName("active job count").desc("Number of active jobs that can run at the same time. Later jobs must wait. The default upper limit is 3000").build();
    private static final Option OVERWRITE_OPTION = Option.builder().longOpt("overwrite").required(false).hasArg(true).numberOfArgs(1).type(Boolean.class).argName("overwrite").desc("Whether to overwrite the destination. Default is true.").build();
    private static final Option BATCH_SIZE_OPTION = Option.builder().longOpt("batch-size").required(false).hasArg(true).numberOfArgs(1).type(Number.class).argName("batch-size").desc("Number of files per request").build();

    public DistributedCpCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "distributedCp";
    }

    public Options getOptions() {
        return new Options().addOption(ACTIVE_JOB_COUNT_OPTION).addOption(OVERWRITE_OPTION).addOption(BATCH_SIZE_OPTION).addOption(ASYNC_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
    }

    public String getUsage() {
        return "distributedCp [--active-jobs <num>] [--batch-size <num>] <src> <dst>";
    }

    public String getDescription() {
        return "Copies a file or directory in parallel at file level.";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        this.mActiveJobs = FileSystemShellUtils.getIntArg(cl, ACTIVE_JOB_COUNT_OPTION, 3000);
        boolean overwrite = FileSystemShellUtils.getBoolArg(cl, OVERWRITE_OPTION, true);
        boolean async = cl.hasOption(ASYNC_OPTION.getLongOpt());
        if (async) {
            System.out.println("Entering async submission mode. ");
        }
        String[] args = cl.getArgs();
        AlluxioURI srcPath = new AlluxioURI(args[0]);
        AlluxioURI dstPath = new AlluxioURI(args[1]);
        if (PathUtils.hasPrefix((String)dstPath.toString(), (String)srcPath.toString())) {
            throw new RuntimeException(ExceptionMessage.MIGRATE_CANNOT_BE_TO_SUBDIRECTORY.getMessage(new Object[]{srcPath, dstPath}));
        }
        AlluxioConfiguration conf = this.mFsContext.getPathConf(dstPath);
        this.mWriteType = (WriteType)conf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.class);
        int defaultBatchSize = conf.getInt(PropertyKey.JOB_REQUEST_BATCH_SIZE);
        int batchSize = FileSystemShellUtils.getIntArg(cl, BATCH_SIZE_OPTION, defaultBatchSize);
        System.out.println("Please wait for command submission to finish..");
        Long jobControlId = this.distributedCp(srcPath, dstPath, overwrite, batchSize);
        if (!async) {
            System.out.format("Submitted successfully, jobControlId = %s%nWaiting for the command to finish ...%n", jobControlId.toString());
            this.waitForCmd(jobControlId);
            this.postProcessing(jobControlId);
        } else {
            System.out.format("Submitted migrate job successfully, jobControlId = %s%n", jobControlId.toString());
        }
        Set<String> failures = this.getFailedFiles();
        if (failures.size() > 0) {
            this.processFailures(args[0], failures, DEFAULT_FAILURE_FILE_PATH);
        }
        return 0;
    }

    private Long distributedCp(AlluxioURI srcPath, AlluxioURI dstPath, boolean overwrite, int batchSize) {
        MigrateCliConfig cmdConfig = new MigrateCliConfig(srcPath.getPath(), dstPath.getPath(), this.mWriteType, overwrite, batchSize);
        return this.submit((CmdConfig)cmdConfig);
    }
}

