/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.ListStatusPOptions;
import alluxio.util.FormatUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class CountCommand
extends AbstractFileSystemCommand {
    @VisibleForTesting
    public static final String COUNT_FORMAT = "%-25s%-25s%-15s%n";
    private static final String READABLE_OPTION_NAME = "h";
    private static final Option READABLE_OPTION = Option.builder((String)"h").required(false).hasArg(false).desc("print sizes in human readable format (e.g. 1KB 234MB 2GB)").build();

    public CountCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "count";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        AtomicLong fileCount = new AtomicLong();
        AtomicLong folderCount = new AtomicLong();
        AtomicLong folderSize = new AtomicLong();
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setRecursive(true).build();
        this.mFileSystem.iterateStatus(inputPath, options, uriStatus -> {
            if (uriStatus.isFolder()) {
                folderCount.incrementAndGet();
            } else {
                fileCount.incrementAndGet();
                folderSize.getAndAdd(uriStatus.getLength());
            }
        });
        this.printInfo(cl.hasOption(READABLE_OPTION_NAME), fileCount.get(), folderCount.get(), folderSize.get());
        return 0;
    }

    private void printInfo(boolean readable, long fileCount, long folderCount, long folderSize) {
        String formatFolderSize = readable ? FormatUtils.getSizeFromBytes((long)folderSize) : String.valueOf(folderSize);
        System.out.format(COUNT_FORMAT, "File Count", "Folder Count", "Folder Size");
        System.out.format(COUNT_FORMAT, fileCount, folderCount, formatFolderSize);
    }

    public String getUsage() {
        return "count [-h] <path>";
    }

    public String getDescription() {
        return "Displays the number of files and directories matching the specified prefix.";
    }

    public Options getOptions() {
        return new Options().addOption(READABLE_OPTION);
    }
}

