/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.SetAttributePOptions;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class ChownCommand
extends AbstractFileSystemCommand {
    private static final Option RECURSIVE_OPTION = Option.builder((String)"R").longOpt("recursive").required(false).hasArg(false).desc("change owner recursively").build();
    private String mGroup;
    private String mOwner;
    private static final Pattern USER_GROUP_PATTERN = Pattern.compile("(?<user>[\\w][\\w-]*\\$?)(:(?<group>[\\w][\\w-]*\\$?))?");

    public ChownCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        if (this.mGroup == null) {
            this.chown(path, this.mOwner, cl.hasOption(RECURSIVE_OPTION.getOpt()));
        } else {
            this.chown(path, this.mOwner, this.mGroup, cl.hasOption(RECURSIVE_OPTION.getOpt()));
        }
    }

    public String getCommandName() {
        return "chown";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
    }

    public Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    private void chown(AlluxioURI path, String owner, boolean recursive) throws AlluxioException, IOException {
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setOwner(owner).setRecursive(recursive).build();
        this.mFileSystem.setAttribute(path, options);
        System.out.println("Changed owner of " + path + " to " + owner);
    }

    private void chown(AlluxioURI path, String owner, String group, boolean recursive) throws AlluxioException, IOException {
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setOwner(owner).setGroup(group).setRecursive(recursive).build();
        this.mFileSystem.setAttribute(path, options);
        System.out.println("Changed owner:group of " + path + " to " + owner + ":" + group + ".");
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[1]);
        Matcher matchUserGroup = USER_GROUP_PATTERN.matcher(args[0]);
        if (matchUserGroup.matches()) {
            this.mOwner = matchUserGroup.group("user");
            this.mGroup = matchUserGroup.group("group");
            this.runWildCardCmd(path, cl);
            return 0;
        }
        System.out.println("Failed to parse " + args[0] + " as user or user:group");
        return -1;
    }

    public String getUsage() {
        return "chown [-R/--recursive] <owner>[:<group>] <path>";
    }

    public String getDescription() {
        return "Changes the owner of a file or directory specified by args. Specify -R/--recursive to change the owner recursively.";
    }
}

