/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.SetAttributePOptions;
import alluxio.security.authorization.Mode;
import alluxio.security.authorization.ModeParser;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class ChmodCommand
extends AbstractFileSystemCommand {
    private static final Option RECURSIVE_OPTION = Option.builder((String)"R").longOpt("recursive").required(false).hasArg(false).desc("change mode recursively").build();
    private String mModeString = "";

    public ChmodCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        this.chmod(plainPath, this.mModeString, cl.hasOption(RECURSIVE_OPTION.getOpt()));
    }

    public String getCommandName() {
        return "chmod";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
    }

    public Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    private void chmod(AlluxioURI path, String modeStr, boolean recursive) throws AlluxioException, IOException {
        Mode mode = ModeParser.parse((String)modeStr);
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setMode(mode.toProto()).setRecursive(recursive).build();
        this.mFileSystem.setAttribute(path, options);
        System.out.println("Changed permission of " + path + " to " + Integer.toOctalString(mode.toShort()));
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        this.mModeString = args[0];
        AlluxioURI path = new AlluxioURI(args[1]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "chmod [-R/--recursive] <mode> <path>";
    }

    public String getDescription() {
        return "Changes the permission of a file or directory specified by args. Specify -R/--recursive to change the permission recursively.";
    }
}

