/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.SetAttributePOptions;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class ChgrpCommand
extends AbstractFileSystemCommand {
    private static final Option RECURSIVE_OPTION = Option.builder((String)"R").longOpt("recursive").required(false).hasArg(false).desc("change group recursively").build();
    private String mGroup;

    public ChgrpCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "chgrp";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
    }

    public Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    private void chgrp(AlluxioURI path, String group, boolean recursive) throws AlluxioException, IOException {
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setGroup(group).setRecursive(recursive).build();
        this.mFileSystem.setAttribute(path, options);
        System.out.println("Changed group of " + path + " to " + group);
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws IOException, AlluxioException {
        this.chgrp(path, this.mGroup, cl.hasOption(RECURSIVE_OPTION.getOpt()));
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        this.mGroup = args[0];
        AlluxioURI path = new AlluxioURI(args[1]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "chgrp [-R/--recursive] <group> <path>";
    }

    public String getDescription() {
        return "Changes the group of a file or directory specified by args. Specify -R/--recursive to change the group recursively.";
    }
}

