/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractFileSystemCommand
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileSystemCommand.class);
    protected FileSystem mFileSystem;
    protected FileSystemContext mFsContext;

    protected AbstractFileSystemCommand(@Nullable FileSystemContext fsContext) {
        if (fsContext == null) {
            fsContext = FileSystemContext.create();
        }
        this.mFsContext = fsContext;
        this.mFileSystem = FileSystem.Factory.create((FileSystemContext)fsContext);
    }

    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
    }

    protected void processHeader(CommandLine cl) throws IOException {
    }

    protected void runWildCardCmd(AlluxioURI wildCardPath, CommandLine cl) throws IOException {
        List<AlluxioURI> paths = FileSystemShellUtils.getAlluxioURIs(this.mFileSystem, wildCardPath);
        if (paths.size() == 0) {
            throw new IOException(wildCardPath + " does not exist.");
        }
        paths.sort(Comparator.comparing(AlluxioURI::getPath));
        this.processHeader(cl);
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (AlluxioURI path : paths) {
            try {
                this.runPlainPath(path, cl);
            }
            catch (AlluxioException | IOException e) {
                LOG.error(String.format("error processing path: %s", path), e);
                errorMessages.add(e.getMessage() != null ? e.getMessage() : e.toString());
            }
        }
        if (errorMessages.size() != 0) {
            throw new IOException(Joiner.on((char)'\n').join(errorMessages));
        }
    }
}

