/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs;

import alluxio.cli.AbstractShell;
import alluxio.cli.Command;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.util.ConfigurationUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class FileSystemShell
extends AbstractShell {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemShell.class);
    private static final Map<String, String[]> CMD_ALIAS = ImmutableMap.builder().put((Object)"umount", (Object)new String[]{"unmount"}).build();
    private static final Set<String> UNSTABLE_ALIAS = ImmutableSet.builder().build();

    public static void main(String[] argv) throws IOException {
        int ret;
        InstancedConfiguration conf = Configuration.modifiableGlobal();
        if (!ConfigurationUtils.masterHostConfigured((AlluxioConfiguration)conf) && argv.length > 0 && !argv[0].equals("help")) {
            System.out.println(ConfigurationUtils.getMasterHostNotConfiguredMessage((String)"Alluxio fs shell"));
            System.exit(1);
        }
        conf.set(PropertyKey.USER_RPC_RETRY_MAX_DURATION, (Object)"5s", Source.DEFAULT);
        try (FileSystemShell shell = new FileSystemShell((AlluxioConfiguration)conf);){
            ret = shell.run(argv);
        }
        System.exit(ret);
    }

    public FileSystemShell(AlluxioConfiguration alluxioConf) {
        super(CMD_ALIAS, UNSTABLE_ALIAS, alluxioConf);
    }

    protected String getShellName() {
        return "fs";
    }

    protected Map<String, Command> loadCommands() {
        return FileSystemShellUtils.loadCommands((FileSystemContext)this.mCloser.register((Closeable)FileSystemContext.create((AlluxioConfiguration)this.mConfiguration)));
    }
}

