/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.docgen;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.util.io.PathUtils;
import com.google.common.base.Objects;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MetricsDocGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsDocGenerator.class);
    private static final String[] CATEGORIES = new String[]{"cluster", "master", "worker", "client", "fuse", "server"};
    private static final String CSV_FILE_DIR = "docs/_data/table/";
    private static final String YML_FILE_DIR = "docs/_data/table/en/";
    private static final String CSV_SUFFIX = "csv";
    private static final String YML_SUFFIX = "yml";
    private static final String CSV_FILE_HEADER = "metricName,metricType";

    public static void generate() throws IOException {
        ArrayList defaultKeys = new ArrayList(MetricKey.allMetricKeys());
        Collections.sort(defaultKeys);
        String homeDir = Configuration.getString((PropertyKey)PropertyKey.HOME);
        HashMap<String, String> metricTypeMap = new HashMap<String, String>();
        for (MetricsSystem.InstanceType type : MetricsSystem.InstanceType.values()) {
            String typeStr = type.toString();
            String category = typeStr.toLowerCase();
            metricTypeMap.put(typeStr, category);
        }
        try (Closer closer = Closer.create();){
            FileWriter ymlFileWriter;
            FileWriter csvFileWriter;
            HashMap<FileWriterKey, FileWriter> fileWriterMap = new HashMap<FileWriterKey, FileWriter>();
            String csvFolder = PathUtils.concatPath((Object)homeDir, (Object)CSV_FILE_DIR);
            String ymlFolder = PathUtils.concatPath((Object)homeDir, (Object)YML_FILE_DIR);
            for (String category : CATEGORIES) {
                csvFileWriter = new FileWriter(PathUtils.concatPath((Object)csvFolder, (Object)(category + "-metrics." + CSV_SUFFIX)));
                csvFileWriter.append("metricName,metricType\n");
                ymlFileWriter = new FileWriter(PathUtils.concatPath((Object)ymlFolder, (Object)(category + "-metrics." + YML_SUFFIX)));
                fileWriterMap.put(new FileWriterKey(category, CSV_SUFFIX), csvFileWriter);
                fileWriterMap.put(new FileWriterKey(category, YML_SUFFIX), ymlFileWriter);
                closer.register((Closeable)csvFileWriter);
                closer.register((Closeable)ymlFileWriter);
            }
            for (MetricKey metricKey : defaultKeys) {
                String key = metricKey.toString();
                String[] components = key.split("\\.");
                if (components.length < 2) {
                    throw new IOException(String.format("The given metric key %s doesn't have two or more components", key));
                }
                if (!metricTypeMap.containsKey(components[0])) {
                    throw new IOException(String.format("The metric key %s starts with invalid instance type %s", key, components[0]));
                }
                csvFileWriter = (FileWriter)fileWriterMap.get(new FileWriterKey((String)metricTypeMap.get(components[0]), CSV_SUFFIX));
                ymlFileWriter = (FileWriter)fileWriterMap.get(new FileWriterKey((String)metricTypeMap.get(components[0]), YML_SUFFIX));
                csvFileWriter.append(String.format("%s,%s%n", key, metricKey.getMetricType().toString()));
                ymlFileWriter.append(String.format("%s:%n  '%s'%n", key, StringEscapeUtils.escapeHtml4((String)metricKey.getDescription().replace("'", "''"))));
            }
        }
        LOG.info("Metrics CSV/YML files were created successfully.");
    }

    private MetricsDocGenerator() {
    }

    public static class FileWriterKey {
        String mCategory;
        String mFileType;

        public FileWriterKey(String category, String fileType) {
            this.mCategory = category;
            this.mFileType = fileType;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileWriterKey)) {
                return false;
            }
            FileWriterKey that = (FileWriterKey)o;
            return Objects.equal((Object)this.mCategory, (Object)that.mCategory) && Objects.equal((Object)this.mFileType, (Object)that.mFileType);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mCategory, this.mFileType});
        }
    }
}

