/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.bundler.command.ExecuteShellCollectInfoCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.PropertyKey;
import alluxio.shell.ShellCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectEnvCommand
extends ExecuteShellCollectInfoCommand {
    public static final String COMMAND_NAME = "collectEnv";
    private static final Logger LOG = LoggerFactory.getLogger(CollectEnvCommand.class);

    public CollectEnvCommand(FileSystemContext fsContext) {
        super(fsContext);
        this.registerCommands();
    }

    @Override
    protected void registerCommands() {
        this.registerCommand("Alluxio ps", new ShellCommand(new String[]{"bash", "-c", "ps", "-ef", "| grep alluxio"}), null);
        this.registerCommand("Spark ps", new ShellCommand(new String[]{"bash", "-c", "ps", "-ef", "| grep spark"}), null);
        this.registerCommand("Yarn ps", new ShellCommand(new String[]{"bash", "-c", "ps", "-ef", "| grep yarn"}), null);
        this.registerCommand("Hdfs ps", new ShellCommand(new String[]{"bash", "-c", "ps", "-ef", "| grep hdfs"}), null);
        this.registerCommand("Presto ps", new ShellCommand(new String[]{"bash", "-c", "ps", "-ef", "| grep presto"}), null);
        this.registerCommand("env", new ShellCommand(new String[]{"env"}), null);
        this.registerCommand("top", new ShellCommand(new String[]{"atop", "-b", "-n", "1"}), new ShellCommand(new String[]{"top", "-b", "-n", "1"}));
        this.registerCommand("mount", new ShellCommand(new String[]{"mount"}), null);
        this.registerCommand("df", new ShellCommand(new String[]{"df", "-H"}), null);
        this.registerCommand("ulimit", new ShellCommand(new String[]{"ulimit", "-Ha"}), null);
        this.registerCommand("uname", new ShellCommand(new String[]{"uname", "-a"}), null);
        this.registerCommand("hostname", new ShellCommand(new String[]{"hostname"}), null);
        this.registerCommand("host ip", new ShellCommand(new String[]{"hostname", "-i"}), null);
        this.registerCommand("host fqdn", new ShellCommand(new String[]{"hostname", "-f"}), null);
        this.registerCommand("list Alluxio home", new ShellCommand(new String[]{String.format("ls", "-al -R %s", this.mFsContext.getClusterConf().get(PropertyKey.HOME))}), null);
        this.registerCommand("dig", new ShellCommand(new String[]{"dig", "$(hostname -i)"}), null);
        this.registerCommand("nslookup", new ShellCommand(new String[]{"nslookup", "$(hostname -i)"}), null);
        this.registerCommand("dstat", new ShellCommand(new String[]{"dstat", "-cdgilmnprsty", "1", "5"}), null);
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public String getUsage() {
        return "collectEnv <outputPath>";
    }

    public String getDescription() {
        return "Collect environment information by running a set of shell commands. ";
    }
}

