/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarUtils {
    public static void compress(String tarballName, File ... files) throws IOException {
        try (TarArchiveOutputStream out = TarUtils.getTarArchiveOutputStream(tarballName);){
            for (File file : files) {
                TarUtils.addToArchiveCompression(out, file, ".");
            }
        }
    }

    public static void decompress(String in, File out) throws IOException {
        try (TarArchiveInputStream fin = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(in)));){
            TarArchiveEntry entry;
            while ((entry = fin.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                File curfile = new File(out, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                IOUtils.copy((InputStream)fin, (OutputStream)new FileOutputStream(curfile));
            }
        }
    }

    private static void addToArchiveCompression(TarArchiveOutputStream out, File file, String dir) throws IOException {
        String entry = dir + File.separator + file.getName();
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null && children.length > 0) {
                for (File child : children) {
                    TarUtils.addToArchiveCompression(out, child, entry);
                }
            }
        } else {
            out.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file, entry));
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            out.closeArchiveEntry();
        }
    }

    private static TarArchiveOutputStream getTarArchiveOutputStream(String path) throws IOException {
        TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(path)));
        taos.setBigNumberMode(1);
        taos.setLongFileMode(2);
        taos.setAddPaxHeadersForNonAsciiNames(true);
        return taos;
    }
}

