/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.util.io.PathUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class RunOperation {
    private static final String BASE_DIRECTORY = "/RunOperationDir";
    @Parameter(names={"-op", "-operation"}, description="the operation to perform. Options are [CreateEmptyFile, CreateAndDeleteEmptyFile, CreateFile, ListStatus]", required=true)
    private Operation mOperation;
    @Parameter(names={"-n", "-num"}, description="the number of times to perform the operation (total for all threads)")
    private int mTimes = 1;
    @Parameter(names={"-t", "-threads"}, description="the number of threads to use")
    private int mThreads = 1;
    @Parameter(names={"-d", "-dir"}, description="The directory to perform operations in")
    private String mDir = "/RunOperationDir";
    @Parameter(names={"-s", "-size"}, description="The size of a file to create")
    private int mSize = 4096;
    private byte[] mFiledata;
    private final FileSystem mFileSystem;
    private AtomicInteger mRemainingOps;

    public static void main(String[] args) {
        System.exit(new RunOperation(Configuration.global()).run(args));
    }

    public RunOperation(AlluxioConfiguration alluxioConf) {
        this.mFileSystem = FileSystem.Factory.create((AlluxioConfiguration)alluxioConf);
    }

    public int run(String[] args) {
        JCommander jc = new JCommander((Object)this);
        jc.setProgramName("runOperation");
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println();
            jc.usage();
            return -1;
        }
        this.mRemainingOps = new AtomicInteger(this.mTimes);
        this.mFiledata = new byte[this.mSize];
        Arrays.fill(this.mFiledata, (byte)122);
        ArrayList<OperationThread> threads = new ArrayList<OperationThread>();
        for (int i = 0; i < this.mThreads; ++i) {
            threads.add(new OperationThread());
        }
        long start = System.currentTimeMillis();
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                return -1;
            }
        }
        System.out.println("Completed in " + (System.currentTimeMillis() - start) + "ms");
        return 0;
    }

    static /* synthetic */ String access$200(RunOperation x0) {
        return x0.mDir;
    }

    static /* synthetic */ Operation access$300(RunOperation x0) {
        return x0.mOperation;
    }

    static /* synthetic */ FileSystem access$400(RunOperation x0) {
        return x0.mFileSystem;
    }

    static /* synthetic */ byte[] access$500(RunOperation x0) {
        return x0.mFiledata;
    }

    private final class OperationThread
    extends Thread {
        private OperationThread() {
        }

        @Override
        public void run() {
            while (RunOperation.this.mRemainingOps.decrementAndGet() >= 0) {
                try {
                    this.applyOperation();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void applyOperation() throws IOException, AlluxioException {
            uri = new AlluxioURI(PathUtils.concatPath((Object)RunOperation.access$200(RunOperation.this), (Object)UUID.randomUUID()));
            switch (1.$SwitchMap$alluxio$cli$RunOperation$Operation[RunOperation.access$300(RunOperation.this).ordinal()]) {
                case 1: {
                    RunOperation.access$400(RunOperation.this).createFile(uri).close();
                    break;
                }
                case 2: {
                    RunOperation.access$400(RunOperation.this).createFile(uri).close();
                    RunOperation.access$400(RunOperation.this).delete(uri);
                    break;
                }
                case 3: {
                    file = RunOperation.access$400(RunOperation.this).createFile(uri, CreateFilePOptions.newBuilder().setRecursive(true).build());
                    var3_3 = null;
                    file.write(RunOperation.access$500(RunOperation.this));
                    if (file == null) break;
                    if (var3_3 == null) ** GOTO lbl23
                    try {
                        file.close();
                    }
                    catch (Throwable var4_4) {
                        var3_3.addSuppressed(var4_4);
                    }
                    break;
lbl23:
                    // 1 sources

                    file.close();
                    break;
                    catch (Throwable var4_5) {
                        try {
                            var3_3 = var4_5;
                            throw var4_5;
                        }
                        catch (Throwable var5_6) {
                            if (file != null) {
                                if (var3_3 != null) {
                                    try {
                                        file.close();
                                    }
                                    catch (Throwable var6_7) {
                                        var3_3.addSuppressed(var6_7);
                                    }
                                } else {
                                    file.close();
                                }
                            }
                            throw var5_6;
                        }
                    }
                }
                case 4: {
                    RunOperation.access$400(RunOperation.this).listStatus(new AlluxioURI(RunOperation.access$200(RunOperation.this)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation: " + (Object)RunOperation.access$300(RunOperation.this));
                }
            }
        }
    }

    static enum Operation {
        CreateFile,
        CreateEmptyFile,
        CreateAndDeleteEmptyFile,
        ListStatus;

    }
}

