/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.ValidationResults;
import alluxio.cli.ValidationTool;
import alluxio.cli.ValidationToolRegistry;
import alluxio.cli.ValidationUtils;
import alluxio.conf.Configuration;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class HmsTests {
    private static final String HELP_OPTION_NAME = "h";
    private static final Option HELP_OPTION = Option.builder((String)"h").required(false).hasArg(false).desc("print help information.").build();
    private static final Option METASTORE_URI_OPTION = Option.builder((String)"m").required(true).hasArg(true).desc("Uri(s) to connect to hive metastore.").build();
    private static final Option DATABASE_OPTION = Option.builder((String)"d").required(false).hasArg(true).desc("Database to run tests against.").build();
    private static final Option TABLES_OPTION = Option.builder((String)"t").required(false).hasArg(true).desc("Tables to run tests against. Multiple tables should be separated with comma.").build();
    private static final Option SOCKET_TIMEOUT_OPTION = Option.builder((String)"st").required(false).hasArg(true).desc("Socket timeout of hive metastore client in minutes. Consider increasing this if you have tables with a lot of metadata.").build();
    private static final Options OPTIONS = new Options().addOption(HELP_OPTION).addOption(METASTORE_URI_OPTION).addOption(DATABASE_OPTION).addOption(TABLES_OPTION).addOption(SOCKET_TIMEOUT_OPTION);

    private static void printUsage() {
        new HelpFormatter().printHelp("alluxio runHmsTests", "Test the configuration, connectivity, and permission of an existing hive metastore", OPTIONS, "e.g. options '-m thrift://hms_host:9083 -d tpcds -t store_sales,web_sales -st 20'will connect to the hive metastore and run tests against the given database and tables.", true);
    }

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(OPTIONS, args, true);
        }
        catch (ParseException e) {
            HmsTests.printUsage();
            System.exit(1);
        }
        if (cmd.hasOption(HELP_OPTION_NAME)) {
            HmsTests.printUsage();
            return;
        }
        String metastoreUri = cmd.getOptionValue("m");
        String database = cmd.getOptionValue("d", "");
        String tables = cmd.getOptionValue("t", "");
        int socketTimeout = Integer.parseInt(cmd.getOptionValue("st", "-1"));
        ValidationToolRegistry registry = new ValidationToolRegistry(Configuration.global());
        registry.refresh();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("metastore_uri", metastoreUri);
        configMap.put("database", database);
        configMap.put("tables", tables);
        configMap.put("socket_timeout", socketTimeout);
        ValidationTool tests = registry.create("hms", configMap);
        String result = ValidationTool.toJson((ValidationResults)ValidationTool.convertResults((List)tests.runAllTests()));
        System.out.println(result);
        if (result.contains(ValidationUtils.State.FAILED.toString())) {
            System.exit(-1);
        }
        System.exit(0);
    }
}

