/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.ClientContext;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.PropertyKey;
import alluxio.grpc.ConfigProperty;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.master.MasterClientContext;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class GetConf {
    private static final String USAGE = "USAGE: GetConf [--unit <arg>] [--source] [--master] [key]\n\nGetConf prints the configured value for the given key. If the key is invalid, the exit code will be nonzero. If the key is valid but isn't set, an empty string is printed. If no key is specified, all configuration is printed.";
    private static final String MASTER_OPTION_NAME = "master";
    private static final String SOURCE_OPTION_NAME = "source";
    private static final String UNIT_OPTION_NAME = "unit";
    private static final Option MASTER_OPTION = Option.builder().required(false).longOpt("master").hasArg(false).desc("the configuration properties used by the master.").build();
    private static final Option SOURCE_OPTION = Option.builder().required(false).longOpt("source").hasArg(false).desc("source of the configuration property will be printed.").build();
    private static final Option UNIT_OPTION = Option.builder().required(false).longOpt("unit").hasArg(true).desc("unit of the value to return. Values of configuration will be converted to a quantity in the given unit. E.g., with \"--unit KB\", a configuration value of \"4096B\" will return 4, and with \"--unit S\", a configuration value of \"5000ms\" will return 5. Possible unit options include B, KB, MB, GB, TP, PB, MS, S, M, H, D. \"").build();
    private static final Options OPTIONS = new Options().addOption(SOURCE_OPTION).addOption(UNIT_OPTION).addOption(MASTER_OPTION);

    public static void printHelp(String message) {
        System.err.println(message);
        HelpFormatter help = new HelpFormatter();
        help.printHelp(USAGE, OPTIONS);
    }

    public static int getConf(ClientContext ctx, String ... args) {
        return GetConf.getConfImpl(() -> new RetryHandlingMetaMasterConfigClient(MasterClientContext.newBuilder((ClientContext)ctx).build()), ctx.getClusterConf(), args);
    }

    @VisibleForTesting
    public static int getConfImpl(Supplier<RetryHandlingMetaMasterConfigClient> clientSupplier, AlluxioConfiguration alluxioConf, String ... args) {
        HashMap<String, ConfigProperty> confMap;
        CommandLine cmd;
        block33: {
            DefaultParser parser = new DefaultParser();
            try {
                cmd = parser.parse(OPTIONS, args, true);
            }
            catch (ParseException e) {
                GetConf.printHelp("Unable to parse input args: " + e.getMessage());
                return 1;
            }
            args = cmd.getArgs();
            confMap = new HashMap<String, ConfigProperty>();
            if (cmd.hasOption(MASTER_OPTION_NAME)) {
                try (RetryHandlingMetaMasterConfigClient client = clientSupplier.get();){
                    client.getConfiguration(GetConfigurationPOptions.newBuilder().setIgnorePathConf(true).build()).getClusterConf().forEach(prop -> confMap.put(prop.getName(), prop.toProto()));
                    break block33;
                }
                catch (IOException e) {
                    System.out.println("Unable to get master-side configuration: " + e.getMessage());
                    return -1;
                }
            }
            for (PropertyKey key : alluxioConf.keySet()) {
                if (!key.isBuiltIn()) continue;
                ConfigProperty.Builder config = ConfigProperty.newBuilder().setName(key.getName()).setSource(alluxioConf.getSource(key).toString());
                Object val = alluxioConf.getOrDefault(key, null, ConfigurationValueOptions.defaults().useDisplayValue(true));
                if (val != null) {
                    config.setValue(String.valueOf(val));
                }
                confMap.put(key.getName(), config.build());
            }
        }
        StringBuilder output = new StringBuilder();
        switch (args.length) {
            case 0: {
                ArrayList properties = new ArrayList(confMap.values());
                properties.sort(Comparator.comparing(ConfigProperty::getName));
                for (ConfigProperty property : properties) {
                    String value = ConfigurationUtils.valueAsString((String)property.getValue());
                    output.append(String.format("%s=%s", property.getName(), value));
                    if (cmd.hasOption(SOURCE_OPTION_NAME)) {
                        output.append(String.format(" (%s)", property.getSource()));
                    }
                    output.append("\n");
                }
                System.out.print(output);
                break;
            }
            case 1: {
                ConfigProperty property;
                if (!PropertyKey.isValid((String)args[0])) {
                    GetConf.printHelp(String.format("%s is not a valid configuration key", args[0]));
                    return 1;
                }
                String key = PropertyKey.fromString((String)args[0]).getName();
                property = (ConfigProperty)confMap.get(key);
                if (property == null) {
                    GetConf.printHelp(String.format("%s is not found", key));
                    return 1;
                }
                if (cmd.hasOption(SOURCE_OPTION_NAME)) {
                    System.out.println(property.getSource());
                    break;
                }
                if (cmd.hasOption(UNIT_OPTION_NAME)) {
                    String arg = cmd.getOptionValue(UNIT_OPTION_NAME).toUpperCase();
                    try {
                        ByteUnit byteUnit = ByteUnit.valueOf(arg);
                        System.out.println(FormatUtils.parseSpaceSize((String)property.getValue()) / byteUnit.getValue());
                        break;
                    }
                    catch (Exception byteUnit) {
                        try {
                            TimeUnit timeUnit = TimeUnit.valueOf(arg);
                            System.out.println(FormatUtils.parseTimeSize((String)property.getValue()) / timeUnit.getValue());
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            GetConf.printHelp(String.format("%s is not a valid unit", arg));
                            return 1;
                        }
                    }
                }
                System.out.println(property.getValue());
                break;
            }
            default: {
                GetConf.printHelp(String.format("More arguments than expected. Args: %s", Arrays.toString(args)));
                return 1;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        System.exit(GetConf.getConf(ClientContext.create(), args));
    }

    private GetConf() {
    }

    private static enum TimeUnit {
        MS(1L),
        MILLISECOND(1L),
        S(1000L),
        SEC(1000L),
        SECOND(1000L),
        M(60000L),
        MIN(60000L),
        MINUTE(60000L),
        H(3600000L),
        HR(3600000L),
        HOUR(3600000L),
        D(86400000L),
        DAY(86400000L);

        private final long mValue;

        public long getValue() {
            return this.mValue;
        }

        private TimeUnit(long value) {
            this.mValue = value;
        }
    }

    private static enum ByteUnit {
        B(1L),
        KB(1024L),
        MB(0x100000L),
        GB(0x40000000L),
        TB(0x10000000000L),
        PB(0x4000000000000L);

        private final long mValue;

        public long getValue() {
            return this.mValue;
        }

        private ByteUnit(long value) {
            this.mValue = value;
        }
    }
}

