/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.docgen.ConfigurationDocGenerator;
import alluxio.cli.docgen.MetricsDocGenerator;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DocGenerator {
    private static final String USAGE = "USAGE: DocGenerator [--metric] [--conf]\n\nDocGenerator generates the docs for metric keys and/or property keys. It will generate all the docs by default unless --metric or --conf is given.";
    private static final String METRIC_OPTION_NAME = "metric";
    private static final String CONF_OPTION_NAME = "conf";
    private static final Option METRIC_OPTION = Option.builder().required(false).longOpt("metric").hasArg(false).desc("the configuration properties used by the master.").build();
    private static final Option CONF_OPTION = Option.builder().required(false).longOpt("conf").hasArg(false).desc("the configuration properties used by the master.").build();
    private static final Options OPTIONS = new Options().addOption(METRIC_OPTION).addOption(CONF_OPTION);

    public static void main(String[] args) throws IOException {
        if (args.length != 0) {
            CommandLine cmd;
            DefaultParser parser = new DefaultParser();
            try {
                cmd = parser.parse(OPTIONS, args, true);
            }
            catch (ParseException e) {
                DocGenerator.printHelp("Unable to parse input args: " + e.getMessage());
                return;
            }
            if (cmd.hasOption(METRIC_OPTION_NAME)) {
                MetricsDocGenerator.generate();
            }
            if (cmd.hasOption(CONF_OPTION_NAME)) {
                ConfigurationDocGenerator.generate();
            }
        } else {
            MetricsDocGenerator.generate();
            ConfigurationDocGenerator.generate();
        }
    }

    public static void printHelp(String message) {
        System.err.println(message);
        HelpFormatter help = new HelpFormatter();
        help.printHelp(USAGE, OPTIONS);
    }

    private DocGenerator() {
    }
}

