/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.retry.ExponentialBackoffRetry;
import alluxio.retry.RetryPolicy;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.WorkerHealthCheckClient;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlluxioWorkerMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioWorkerMonitor.class);
    public static final Supplier<RetryPolicy> ONE_MIN_EXP_BACKOFF = () -> new ExponentialBackoffRetry(50, 500, 120);

    public static void main(String[] args) {
        InstancedConfiguration conf;
        WorkerHealthCheckClient client;
        if (args.length != 0) {
            LOG.info("java -cp {} {}", (Object)"target/alluxio-2.8.0-2-jar-with-dependencies.jar", (Object)AlluxioWorkerMonitor.class.getCanonicalName());
            LOG.warn("ignoring arguments");
        }
        if (!(client = new WorkerHealthCheckClient(NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.WORKER_RPC, (AlluxioConfiguration)(conf = new InstancedConfiguration(ConfigurationUtils.defaults()))), ONE_MIN_EXP_BACKOFF, (AlluxioConfiguration)conf)).isServing()) {
            System.exit(1);
        }
        System.exit(0);
    }

    private AlluxioWorkerMonitor() {
    }
}

