/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.HealthCheckClient;
import alluxio.common.RpcPortHealthCheckClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.grpc.ServiceType;
import alluxio.master.AlluxioMasterMonitor;
import alluxio.master.MasterInquireClient;
import alluxio.retry.RetryPolicy;
import alluxio.security.user.UserState;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.ShellUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterHealthCheckClient
implements HealthCheckClient {
    private static final Logger LOG = LoggerFactory.getLogger(MasterHealthCheckClient.class);
    private MasterType mAlluxioMasterType;
    private boolean mProcessCheck;
    private ExecutorService mExecutorService;
    private Supplier<RetryPolicy> mPolicySupplier;
    private AlluxioConfiguration mConf;

    public MasterHealthCheckClient(MasterType alluxioMasterType, boolean processCheck, Supplier<RetryPolicy> retryPolicySupplier, AlluxioConfiguration alluxioConf) {
        this.mAlluxioMasterType = alluxioMasterType;
        this.mProcessCheck = processCheck;
        this.mExecutorService = Executors.newFixedThreadPool(2);
        this.mPolicySupplier = retryPolicySupplier;
        this.mConf = alluxioConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServing() {
        try {
            InetSocketAddress connectAddr;
            ServiceType rpcService;
            switch (this.mAlluxioMasterType) {
                case MASTER: {
                    rpcService = ServiceType.FILE_SYSTEM_MASTER_CLIENT_SERVICE;
                    connectAddr = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)this.mConf);
                    break;
                }
                case JOB_MASTER: {
                    rpcService = ServiceType.JOB_MASTER_CLIENT_SERVICE;
                    connectAddr = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, (AlluxioConfiguration)this.mConf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Master type %s is invalid", new Object[]{this.mAlluxioMasterType}));
                }
            }
            MasterServingHealthCheck masterRpcCheck = new MasterServingHealthCheck(connectAddr, rpcService, this.mPolicySupplier, this.mConf);
            Future<?> masterServingFuture = this.mExecutorService.submit(masterRpcCheck);
            if (this.mProcessCheck) {
                Future<?> processCheckFuture = this.mExecutorService.submit(new ProcessCheckRunnable(this.mAlluxioMasterType.getClassName()));
                CommonUtils.sleepMs((long)1000L);
                if (!ConfigurationUtils.isHaMode((AlluxioConfiguration)this.mConf)) {
                    while (!masterServingFuture.isDone()) {
                        if (processCheckFuture.isDone()) {
                            throw new IllegalStateException("One or more master processes are not running");
                        }
                        CommonUtils.sleepMs((long)1000L);
                    }
                }
                CommonUtils.sleepMs((long)7000L);
                LOG.debug("Checking the master processes one more time...");
                boolean bl = !processCheckFuture.isDone();
                return bl;
            }
            masterServingFuture.get();
            boolean bl = masterRpcCheck.serving();
            return bl;
        }
        catch (Exception e) {
            LOG.error("Exception thrown in master health check client", (Throwable)e);
        }
        finally {
            this.mExecutorService.shutdown();
        }
        return false;
    }

    public final class ProcessCheckRunnable
    implements Runnable {
        private String mAlluxioMasterName;

        public ProcessCheckRunnable(String alluxioMasterName) {
            this.mAlluxioMasterName = alluxioMasterName;
        }

        @Override
        public void run() {
            UserState userState = UserState.Factory.create((AlluxioConfiguration)MasterHealthCheckClient.this.mConf);
            MasterInquireClient client = MasterInquireClient.Factory.create((AlluxioConfiguration)MasterHealthCheckClient.this.mConf, (UserState)userState);
            try {
                while (true) {
                    List addresses = client.getMasterRpcAddresses();
                    for (InetSocketAddress address : addresses) {
                        String host = address.getHostName();
                        int port = address.getPort();
                        LOG.debug("Master health check on node {}", (Object)host);
                        String cmd = String.format("ssh %s %s %s", "-o StrictHostKeyChecking=no -o ConnectTimeout=5", host, "ps -ef | grep \"" + this.mAlluxioMasterName + "$\" | grep \"java\" | awk '{ print $2; }'");
                        LOG.debug("Executing: {}", (Object)cmd);
                        String output = ShellUtils.execCommand((String[])new String[]{"bash", "-c", cmd});
                        if (output.isEmpty()) {
                            throw new IllegalStateException(String.format("Master process is not running on the host %s", host));
                        }
                        if (output.contains("Connection refused")) {
                            throw new IllegalStateException(String.format("Connection refused while connecting to the host %s on port %d", host, port));
                        }
                        LOG.debug("Master running on node {} with pid={}", (Object)host, (Object)output);
                    }
                    CommonUtils.sleepMs((long)1000L);
                }
            }
            catch (Throwable e) {
                LOG.error("Exception thrown in the master process check", e);
                throw new RuntimeException(e);
            }
        }
    }

    public final class MasterServingHealthCheck
    extends RpcPortHealthCheckClient
    implements Runnable {
        private AtomicBoolean mIsServing;

        public MasterServingHealthCheck(InetSocketAddress nodeAddress, ServiceType serviceType, Supplier<RetryPolicy> retryPolicySupplier, AlluxioConfiguration alluxioConf) {
            super(nodeAddress, serviceType, retryPolicySupplier, alluxioConf);
            this.mIsServing = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            if (super.isServing()) {
                this.mIsServing.set(true);
            }
        }

        public boolean serving() {
            return this.mIsServing.get();
        }
    }

    public static class Builder {
        private boolean mProcessCheck = true;
        private MasterType mAlluxioMasterType = MasterType.MASTER;
        private AlluxioConfiguration mConf;
        private Supplier<RetryPolicy> mPolicySupplier;

        public Builder(AlluxioConfiguration alluxioConf) {
            this.mConf = alluxioConf;
            this.mPolicySupplier = AlluxioMasterMonitor.TWO_MIN_EXP_BACKOFF;
        }

        public Builder withProcessCheck(boolean processCheck) {
            this.mProcessCheck = processCheck;
            return this;
        }

        public Builder withConfiguration(AlluxioConfiguration alluxioConf) {
            this.mConf = alluxioConf;
            return this;
        }

        public Builder withAlluxioMasterType(MasterType masterType) {
            this.mAlluxioMasterType = masterType;
            return this;
        }

        public Builder withRetryPolicy(Supplier<RetryPolicy> policySupplier) {
            this.mPolicySupplier = policySupplier;
            return this;
        }

        public HealthCheckClient build() {
            return new MasterHealthCheckClient(this.mAlluxioMasterType, this.mProcessCheck, this.mPolicySupplier, this.mConf);
        }
    }

    public static enum MasterType {
        MASTER("alluxio.master.AlluxioMaster"),
        JOB_MASTER("alluxio.master.AlluxioJobMaster");

        private String mClassName;

        private MasterType(String className) {
            this.mClassName = className;
        }

        public String getClassName() {
            return this.mClassName;
        }
    }
}

