/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.job.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.util.DistributedCommandUtil;
import alluxio.client.file.FileSystemContext;
import alluxio.client.job.JobContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.resource.CloseableResource;
import alluxio.security.user.UserState;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GetCmdStatusCommand
extends AbstractFileSystemCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GetCmdStatusCommand.class);

    public GetCmdStatusCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "getCmdStatus";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public String getUsage() {
        return "getCmdStatus <jobControlId>";
    }

    public String getDescription() {
        return "Get the status information for a distributed command.";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        long jobControlId = Long.parseLong(args[0]);
        HashSet failedFiles = Sets.newHashSet();
        ArrayList completedFiles = Lists.newArrayList();
        try (CloseableResource client = JobContext.create((AlluxioConfiguration)this.mFsContext.getClusterConf(), (UserState)this.mFsContext.getClientContext().getUserState()).acquireMasterClientResource();){
            DistributedCommandUtil.getDetailedCmdStatus(jobControlId, (JobMasterClient)client.get(), failedFiles, completedFiles);
            if (!failedFiles.isEmpty()) {
                System.out.println("Failed files are:");
                failedFiles.forEach(System.out::println);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get detailed status of the command", (Throwable)e);
            System.out.println(String.format("Unable to get detailed information for command %s. For distributedLoad, the files may already be loaded in Alluxio. For distributedCp, please check file source contains files or not. Please retry using `getCmdStatus` to check command detailed status, or using `fs ls` command to check if the files are already loaded.", jobControlId));
            return -1;
        }
        return 0;
    }
}

