/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.report;

import alluxio.client.file.FileSystemMasterClient;
import alluxio.util.FormatUtils;
import alluxio.wire.MountPointInfo;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class UfsCommand {
    private FileSystemMasterClient mFileSystemMasterClient;

    public UfsCommand(FileSystemMasterClient fileSystemMasterClient) {
        this.mFileSystemMasterClient = fileSystemMasterClient;
    }

    public int run() throws IOException {
        Map mountTable = this.mFileSystemMasterClient.getMountTable();
        System.out.println("Alluxio under storage system information:");
        UfsCommand.printMountInfo(mountTable);
        return 0;
    }

    public static void printMountInfo(Map<String, MountPointInfo> mountTable) {
        for (Map.Entry<String, MountPointInfo> entry : mountTable.entrySet()) {
            String mMountPoint = entry.getKey();
            MountPointInfo mountPointInfo = entry.getValue();
            long capacityBytes = mountPointInfo.getUfsCapacityBytes();
            long usedBytes = mountPointInfo.getUfsUsedBytes();
            String usedPercentageInfo = "";
            if (capacityBytes > 0L) {
                int usedPercentage = (int)(100.0 * (double)usedBytes / (double)capacityBytes);
                usedPercentageInfo = String.format("(%s%%)", usedPercentage);
            }
            String leftAlignFormat = UfsCommand.getAlignFormat(mountTable);
            System.out.format(leftAlignFormat, mountPointInfo.getUfsUri(), mMountPoint, mountPointInfo.getUfsType(), FormatUtils.getSizeFromBytes((long)capacityBytes), FormatUtils.getSizeFromBytes((long)usedBytes) + usedPercentageInfo, mountPointInfo.getReadOnly() ? "" : "not ", mountPointInfo.getShared() ? "" : "not ");
            System.out.println("properties=" + mountPointInfo.getProperties() + ")");
        }
    }

    private static String getAlignFormat(Map<String, MountPointInfo> mountTable) {
        int mountPointLength = mountTable.entrySet().stream().map(w -> ((String)w.getKey()).length()).max(Comparator.comparing(Integer::intValue)).get();
        int usfLength = mountTable.entrySet().stream().map(w -> ((MountPointInfo)w.getValue()).getUfsUri().length()).max(Comparator.comparing(Integer::intValue)).get();
        String leftAlignFormat = "%-" + usfLength + "s  on  %-" + mountPointLength + "s  (%s, capacity=%s, used=%s, %sread-only, %sshared, ";
        return leftAlignFormat;
    }
}

