/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.report;

import alluxio.client.job.JobMasterClient;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.JobServiceSummary;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.job.wire.StatusSummary;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JobServiceMetricsCommand {
    private final JobMasterClient mJobMasterClient;
    private final PrintStream mPrintStream;
    private final String mDateFormatPattern;

    public JobServiceMetricsCommand(JobMasterClient JobMasterClient2, PrintStream printStream, String dateFormatPattern) {
        this.mJobMasterClient = JobMasterClient2;
        this.mPrintStream = printStream;
        this.mDateFormatPattern = dateFormatPattern;
    }

    public int run() throws IOException {
        List allWorkerHealth = this.mJobMasterClient.getAllWorkerHealth();
        for (JobWorkerHealth workerHealth : allWorkerHealth) {
            this.mPrintStream.print(String.format("Worker: %-10s  ", workerHealth.getHostname()));
            this.mPrintStream.print(String.format("Task Pool Size: %-7s", workerHealth.getTaskPoolSize()));
            this.mPrintStream.print(String.format("Unfinished Tasks: %-7s", workerHealth.getUnfinishedTasks()));
            this.mPrintStream.print(String.format("Active Tasks: %-7s", workerHealth.getNumActiveTasks()));
            this.mPrintStream.println(String.format("Load Avg: %s", StringUtils.join((Iterable)workerHealth.getLoadAverage(), (String)", ")));
        }
        this.mPrintStream.println();
        JobServiceSummary jobServiceSummary = this.mJobMasterClient.getJobServiceSummary();
        Collection jobStatusSummaries = jobServiceSummary.getSummaryPerStatus();
        for (StatusSummary statusSummary : jobStatusSummaries) {
            this.mPrintStream.print(String.format("Status: %-10s", statusSummary.getStatus()));
            this.mPrintStream.println(String.format("Count: %s", statusSummary.getCount()));
        }
        this.mPrintStream.println();
        this.mPrintStream.println(String.format("%s Most Recently Modified Jobs:", 10));
        List lastActivities = jobServiceSummary.getRecentActivities();
        this.printJobInfos(lastActivities);
        this.mPrintStream.println(String.format("%s Most Recently Failed Jobs:", 10));
        List lastFailures = jobServiceSummary.getRecentFailures();
        this.printJobInfos(lastFailures);
        this.mPrintStream.println(String.format("%s Longest Running Jobs:", 10));
        List longestRunning = jobServiceSummary.getLongestRunning();
        this.printJobInfos(longestRunning);
        return 0;
    }

    private void printJobInfos(List<JobInfo> jobInfos) {
        for (JobInfo jobInfo : jobInfos) {
            this.mPrintStream.print(String.format("Timestamp: %-30s", CommonUtils.convertMsToDate((long)jobInfo.getLastUpdated(), (String)this.mDateFormatPattern)));
            this.mPrintStream.print(String.format("Id: %-20s", jobInfo.getId()));
            this.mPrintStream.print(String.format("Name: %-20s", jobInfo.getName()));
            this.mPrintStream.println(String.format("Status: %s", jobInfo.getStatus()));
        }
        this.mPrintStream.println();
    }
}

