/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.pathconf;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.InvalidArgumentException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class RemoveCommand
extends AbstractFsAdminCommand {
    public static final String KEYS_OPTION_NAME = "keys";
    private static final Option KEYS_OPTION = Option.builder().longOpt("keys").required(false).hasArg(true).numberOfArgs(1).desc("properties keys to be removed from this path's configurations, separated by comma").build();

    public RemoveCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "remove";
    }

    public Options getOptions() {
        return new Options().addOption(KEYS_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public int run(CommandLine cl) throws IOException {
        AlluxioURI path = new AlluxioURI(cl.getArgs()[0]);
        if (cl.hasOption(KEYS_OPTION_NAME)) {
            String[] keys = cl.getOptionValue(KEYS_OPTION_NAME).split(",");
            HashSet<PropertyKey> propertyKeys = new HashSet<PropertyKey>();
            for (String key : keys) {
                propertyKeys.add(PropertyKey.fromString((String)key));
            }
            this.mMetaConfigClient.removePathConfiguration(path, propertyKeys);
        } else {
            this.mMetaConfigClient.removePathConfiguration(path);
        }
        return 0;
    }

    public String getUsage() {
        return String.format("%s [--%s <key1,key2,key3>] <path>%n\t--%s: %s", this.getCommandName(), KEYS_OPTION_NAME, KEYS_OPTION_NAME, KEYS_OPTION.getDescription());
    }

    @VisibleForTesting
    public static String description() {
        return "Removes all or specific properties from path's path level configurations.";
    }

    public String getDescription() {
        return RemoveCommand.description();
    }
}

