/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.journal;

import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.cli.fsadmin.journal.QuorumCommand;
import alluxio.client.journal.JournalMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.JournalDomain;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class QuorumRemoveCommand
extends AbstractFsAdminCommand {
    public static final String ADDRESS_OPTION_NAME = "address";
    public static final String DOMAIN_OPTION_NAME = "domain";
    public static final String OUTPUT_RESULT = "Removed server at: %s from quorum: %s";

    public QuorumRemoveCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    @VisibleForTesting
    public static String description() {
        return "Removes a server from embedded journal quorum.";
    }

    public int run(CommandLine cl) throws IOException {
        JournalMasterClient jmClient = this.mMasterJournalMasterClient;
        String domainVal = cl.getOptionValue(DOMAIN_OPTION_NAME);
        try {
            JournalDomain domain = JournalDomain.valueOf((String)domainVal);
            if (domain == JournalDomain.JOB_MASTER) {
                jmClient = this.mJobMasterJournalMasterClient;
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_OPTION_VALUE.getMessage(new Object[]{DOMAIN_OPTION_NAME, Arrays.toString(JournalDomain.values())}));
        }
        String serverAddress = cl.getOptionValue(ADDRESS_OPTION_NAME);
        jmClient.removeQuorumServer(QuorumCommand.stringToAddress(serverAddress));
        this.mPrintStream.println(String.format(OUTPUT_RESULT, serverAddress, domainVal));
        return 0;
    }

    public String getCommandName() {
        return "remove";
    }

    public String getUsage() {
        return String.format("%s -%s <MASTER|JOB_MASTER>%n -%s <HostName:Port>", this.getCommandName(), DOMAIN_OPTION_NAME, ADDRESS_OPTION_NAME);
    }

    public String getDescription() {
        return QuorumRemoveCommand.description();
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        if (cl.getOptions().length != 2) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_OPTION_COUNT.getMessage(new Object[]{2, cl.getOptions().length}));
        }
        if (!cl.hasOption(DOMAIN_OPTION_NAME) || !cl.hasOption(ADDRESS_OPTION_NAME)) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_OPTION.getMessage(new Object[]{String.format("[%s, %s]", DOMAIN_OPTION_NAME, ADDRESS_OPTION_NAME)}));
        }
    }

    public Options getOptions() {
        return new Options().addOption(DOMAIN_OPTION_NAME, true, "Journal domain").addOption(ADDRESS_OPTION_NAME, true, "Server address to remove");
    }
}

