/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.journal;

import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.client.journal.JournalMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.GetQuorumInfoPResponse;
import alluxio.grpc.JournalDomain;
import alluxio.grpc.NetAddress;
import alluxio.grpc.QuorumServerInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class QuorumInfoCommand
extends AbstractFsAdminCommand {
    public static final String DOMAIN_OPTION_NAME = "domain";
    public static final String OUTPUT_HEADER_DOMAIN = "Journal domain\t: %s";
    public static final String OUTPUT_HEADER_QUORUM_SIZE = "Quorum size\t: %d";
    public static final String OUTPUT_HEADER_LEADING_MASTER = "Quorum leader\t: %s";
    public static final String OUTPUT_SERVER_INFO = "%-11s | %-8s | %s%n";

    public QuorumInfoCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    @VisibleForTesting
    public static String description() {
        return "Shows quorum information for embedded journal.";
    }

    public int run(CommandLine cl) throws IOException {
        JournalMasterClient jmClient = this.mMasterJournalMasterClient;
        String domainVal = cl.getOptionValue(DOMAIN_OPTION_NAME);
        try {
            JournalDomain domain = JournalDomain.valueOf((String)domainVal);
            if (domain == JournalDomain.JOB_MASTER) {
                jmClient = this.mJobMasterJournalMasterClient;
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_OPTION_VALUE.getMessage(new Object[]{DOMAIN_OPTION_NAME, Arrays.toString(JournalDomain.values())}));
        }
        GetQuorumInfoPResponse quorumInfo = jmClient.getQuorumInfo();
        Optional<QuorumServerInfo> leadingMasterInfoOpt = quorumInfo.getServerInfoList().stream().filter(QuorumServerInfo::getIsLeader).findFirst();
        String leadingMasterAddr = leadingMasterInfoOpt.isPresent() ? this.netAddressToString(leadingMasterInfoOpt.get().getServerAddress()) : "UNKNOWN";
        List table = quorumInfo.getServerInfoList().stream().map(info -> new String[]{info.getServerState().toString(), Integer.toString(info.getPriority()), this.netAddressToString(info.getServerAddress())}).collect(Collectors.toList());
        table.add(0, new String[]{"STATE", "PRIORITY", "SERVER ADDRESS"});
        this.mPrintStream.println(String.format(OUTPUT_HEADER_DOMAIN, quorumInfo.getDomain()));
        this.mPrintStream.println(String.format(OUTPUT_HEADER_QUORUM_SIZE, quorumInfo.getServerInfoList().size()));
        this.mPrintStream.println(String.format(OUTPUT_HEADER_LEADING_MASTER, leadingMasterAddr));
        this.mPrintStream.println();
        for (Object[] output : table) {
            this.mPrintStream.printf(OUTPUT_SERVER_INFO, output);
        }
        return 0;
    }

    String netAddressToString(NetAddress address) {
        return String.format("%s:%d", address.getHost(), address.getRpcPort());
    }

    public String getCommandName() {
        return "info";
    }

    public String getUsage() {
        return String.format("%s -%s <%s>%n", this.getCommandName(), DOMAIN_OPTION_NAME, Arrays.toString(JournalDomain.values()));
    }

    public String getDescription() {
        return QuorumInfoCommand.description();
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        if (cl.getOptions().length != 1) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_OPTION_COUNT.getMessage(new Object[]{1, cl.getOptions().length}));
        }
        if (!cl.hasOption(DOMAIN_OPTION_NAME)) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_OPTION.getMessage(new Object[]{String.format("[%s]", DOMAIN_OPTION_NAME)}));
        }
    }

    public Options getOptions() {
        return new Options().addOption(DOMAIN_OPTION_NAME, true, "Journal domain");
    }
}

