/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.doctor;

import alluxio.client.block.BlockMasterClient;
import alluxio.grpc.StorageList;
import alluxio.grpc.WorkerLostStorageInfo;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;

public class StorageCommand {
    private final BlockMasterClient mBlockMasterClient;
    private final PrintStream mPrintStream;

    public StorageCommand(BlockMasterClient blockMasterClient, PrintStream printStream) {
        this.mBlockMasterClient = blockMasterClient;
        this.mPrintStream = printStream;
    }

    public int run() throws IOException {
        List workerLostStorageList = this.mBlockMasterClient.getWorkerLostStorage();
        if (workerLostStorageList.size() == 0) {
            this.mPrintStream.println("All worker storage paths are in working state.");
            return 0;
        }
        for (WorkerLostStorageInfo info : workerLostStorageList) {
            Map lostStorageMap = info.getLostStorageMap();
            if (lostStorageMap.size() == 0) continue;
            this.mPrintStream.printf("The following storage paths are lost in worker %s: %n", info.getAddress().getHost());
            for (Map.Entry tierStorage : lostStorageMap.entrySet()) {
                for (String storage : ((StorageList)tierStorage.getValue()).getStorageList()) {
                    this.mPrintStream.printf("%s (%s)%n", storage, tierStorage.getKey());
                }
            }
        }
        return 0;
    }
}

