/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.UfsPMode;
import alluxio.grpc.UpdateUfsModePOptions;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class UfsCommand
extends AbstractFsAdminCommand {
    private static final Option MODE_OPTION = Option.builder().longOpt("mode").required(false).hasArg(true).desc("Set maintenance mode for a ufs path under one or more Alluxio mount points.").build();

    public UfsCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "ufs";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public Options getOptions() {
        return new Options().addOption(MODE_OPTION);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        String ufsPath = args[0];
        AlluxioURI ufsUri = new AlluxioURI(ufsPath);
        if (!PathUtils.normalizePath((String)ufsUri.getPath(), (String)"/").equals("/")) {
            System.out.println("The ufs path should have only scheme and authority but no path.");
            return -1;
        }
        if (cl.hasOption(MODE_OPTION.getLongOpt())) {
            UfsPMode mode;
            switch (cl.getOptionValue(MODE_OPTION.getLongOpt())) {
                case "noAccess": {
                    mode = UfsPMode.NO_ACCESS;
                    break;
                }
                case "readOnly": {
                    mode = UfsPMode.READ_ONLY;
                    break;
                }
                case "readWrite": {
                    mode = UfsPMode.READ_WRITE;
                    break;
                }
                default: {
                    System.out.println("Unrecognized mode");
                    return -1;
                }
            }
            UpdateUfsModePOptions options = UpdateUfsModePOptions.newBuilder().setUfsMode(mode).build();
            this.mFsClient.updateUfsMode(ufsUri, options);
            System.out.println("Ufs mode updated");
            return 0;
        }
        System.out.println("No attribute to update");
        return 0;
    }

    public String getUsage() {
        return "ufs [--mode <noAccess/readOnly/readWrite>] <ufsPath>";
    }

    public String getDescription() {
        return "Update attributes for a ufs path.";
    }
}

