/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.cli.Command;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.cli.fsadmin.pathconf.AddCommand;
import alluxio.cli.fsadmin.pathconf.ListCommand;
import alluxio.cli.fsadmin.pathconf.RemoveCommand;
import alluxio.cli.fsadmin.pathconf.ShowCommand;
import alluxio.conf.AlluxioConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public final class PathConfCommand
extends AbstractFsAdminCommand {
    private static final Map<String, BiFunction<Context, AlluxioConfiguration, ? extends Command>> SUB_COMMANDS = new HashMap<String, BiFunction<Context, AlluxioConfiguration, ? extends Command>>();
    private Map<String, Command> mSubCommands = new HashMap<String, Command>();

    public PathConfCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
        SUB_COMMANDS.forEach((name, constructor) -> this.mSubCommands.put((String)name, (Command)constructor.apply(context, alluxioConf)));
    }

    public Map<String, Command> getSubCommands() {
        return this.mSubCommands;
    }

    public String getCommandName() {
        return "pathConf";
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder(this.getCommandName());
        for (String cmd : SUB_COMMANDS.keySet()) {
            usage.append(" [").append(cmd).append("]");
        }
        return usage.toString();
    }

    @VisibleForTesting
    public static String description() {
        return "Manage path level configuration, see sub-commands' descriptions for more details.";
    }

    public String getDescription() {
        return PathConfCommand.description();
    }

    static {
        SUB_COMMANDS.put("list", ListCommand::new);
        SUB_COMMANDS.put("show", ShowCommand::new);
        SUB_COMMANDS.put("add", AddCommand::new);
        SUB_COMMANDS.put("remove", RemoveCommand::new);
    }
}

