/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.cli.Command;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.cli.fsadmin.journal.CheckpointCommand;
import alluxio.cli.fsadmin.journal.QuorumCommand;
import alluxio.conf.AlluxioConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class JournalCommand
extends AbstractFsAdminCommand {
    private static final Map<String, BiFunction<Context, AlluxioConfiguration, ? extends Command>> SUB_COMMANDS = new HashMap<String, BiFunction<Context, AlluxioConfiguration, ? extends Command>>();
    private Map<String, Command> mSubCommands = new HashMap<String, Command>();

    public JournalCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
        SUB_COMMANDS.forEach((name, constructor) -> this.mSubCommands.put((String)name, (Command)constructor.apply(context, alluxioConf)));
    }

    @VisibleForTesting
    public static String description() {
        return "Provide operations for the journal. See sub-commands' descriptions for more details.";
    }

    public Map<String, Command> getSubCommands() {
        return this.mSubCommands;
    }

    public String getCommandName() {
        return "journal";
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder(this.getCommandName());
        for (String cmd : SUB_COMMANDS.keySet()) {
            usage.append(" [").append(cmd).append("]");
        }
        return usage.toString();
    }

    public String getDescription() {
        return JournalCommand.description();
    }

    static {
        SUB_COMMANDS.put("checkpoint", CheckpointCommand::new);
        SUB_COMMANDS.put("quorum", QuorumCommand::new);
    }
}

