/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.FileSystemAdminShellUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.cli.fsadmin.doctor.ConfigurationCommand;
import alluxio.cli.fsadmin.doctor.StorageCommand;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class DoctorCommand
extends AbstractFsAdminCommand {
    public static final String HELP_OPTION_NAME = "h";
    private static final Option HELP_OPTION = Option.builder((String)"h").required(false).hasArg(false).desc("print help information.").build();
    private final AlluxioConfiguration mConf;

    public DoctorCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
        this.mConf = alluxioConf;
    }

    public String getCommandName() {
        return "doctor";
    }

    public int run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        if (cl.hasOption(HELP_OPTION_NAME)) {
            System.out.println(this.getUsage());
            System.out.println(this.getDescription());
            return 0;
        }
        FileSystemAdminShellUtils.checkMasterClientService(this.mConf);
        Command command = Command.ALL;
        if (args.length == 1) {
            switch (args[0]) {
                case "configuration": {
                    command = Command.CONFIGURATION;
                    break;
                }
                case "storage": {
                    command = Command.STORAGE;
                    break;
                }
                default: {
                    System.out.println(this.getUsage());
                    System.out.println(this.getDescription());
                    throw new InvalidArgumentException("doctor category is invalid.");
                }
            }
        }
        if (command.equals((Object)Command.CONFIGURATION) || command.equals((Object)Command.ALL)) {
            ConfigurationCommand configurationCommand = new ConfigurationCommand(this.mMetaClient, System.out);
            configurationCommand.run();
        }
        if (command.equals((Object)Command.STORAGE) || command.equals((Object)Command.ALL)) {
            StorageCommand storageCommand = new StorageCommand(this.mBlockClient, System.out);
            storageCommand.run();
        }
        return 0;
    }

    public String getUsage() {
        return DoctorCommand.usage();
    }

    @VisibleForTesting
    public static String usage() {
        return "doctor [category]";
    }

    public String getDescription() {
        return DoctorCommand.description();
    }

    @VisibleForTesting
    public static String description() {
        return "Show Alluxio errors and warnings.\nWhere [category] is an optional argument. If no arguments are passed in, all categories of errors/warnings will be printed out.\n[category] can be one of the following:\n    configuration    server-side configuration errors/warnings\n    storage          worker lost storage warnings\n";
    }

    public Options getOptions() {
        return new Options().addOption(HELP_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoMoreThan((alluxio.cli.Command)this, (CommandLine)cl, (int)1);
    }

    static enum Command {
        ALL,
        CONFIGURATION,
        STORAGE;

    }
}

