/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.BackupPOptions;
import alluxio.grpc.BackupPRequest;
import alluxio.grpc.BackupState;
import alluxio.wire.BackupStatus;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;

public class BackupCommand
extends AbstractFsAdminCommand {
    private static final Option LOCAL_OPTION = Option.builder().longOpt("local").required(false).hasArg(false).desc("whether to write the backup to the master's local filesystem instead of the root UFS").build();
    private static final Option ALLOW_LEADER_OPTION = Option.builder().longOpt("allow-leader").required(false).hasArg(false).desc("whether to allow leader to take the backup when backup delegation is enabled and HA cluster has no standby master.").build();
    private static final Option BYPASS_DELEGATION_OPTION = Option.builder().longOpt("bypass-delegation").required(false).hasArg(false).desc("when specified, the leading master will by-pass backup delegation, if it was enabled by configuration.").build();

    public BackupCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "backup";
    }

    public Options getOptions() {
        return new Options().addOption(LOCAL_OPTION).addOption(ALLOW_LEADER_OPTION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        BackupPRequest.Builder opts = BackupPRequest.newBuilder();
        if (args.length >= 1) {
            opts.setTargetDirectory(args[0]);
        }
        opts.setOptions(BackupPOptions.newBuilder().setRunAsync(true).setLocalFileSystem(cl.hasOption(LOCAL_OPTION.getLongOpt())).setAllowLeader(cl.hasOption(ALLOW_LEADER_OPTION.getLongOpt())).setBypassDelegation(cl.hasOption(BYPASS_DELEGATION_OPTION.getLongOpt())));
        BackupStatus status = this.mMetaClient.backup(opts.build());
        UUID backupId = status.getBackupId();
        while (true) {
            this.clearProgressLine();
            if (status.getState() == BackupState.None) {
                this.mPrintStream.printf("Backup lost. Please check Alluxio logs.%n", new Object[0]);
                return -1;
            }
            if (status.getState() == BackupState.Completed) {
                this.clearProgressLine();
                this.mPrintStream.printf("Backup Host        : %s%n", status.getHostname());
                this.mPrintStream.printf("Backup URI         : %s%n", status.getBackupUri());
                this.mPrintStream.printf("Backup Entry Count : %d%n", status.getEntryCount());
                return 0;
            }
            if (status.getState() == BackupState.Failed) {
                throw AlluxioStatusException.fromAlluxioException((AlluxioException)status.getError());
            }
            String progressMessage = String.format(" Backup state: %s", status.getState());
            if (status.getState() == BackupState.Running) {
                progressMessage = progressMessage + String.format(" | Entries processed: %d", status.getEntryCount());
            }
            this.mPrintStream.write(progressMessage.getBytes());
            this.mPrintStream.write("\r".getBytes());
            this.mPrintStream.flush();
            try {
                Thread.sleep(500L);
                status = this.mMetaClient.getBackupStatus(backupId);
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Interrupted while waiting for backup completion.");
            }
            finally {
                this.clearProgressLine();
                continue;
            }
            break;
        }
    }

    private void clearProgressLine() throws IOException {
        int progressLineLength = 75;
        this.mPrintStream.write(StringUtils.repeat((String)" ", (int)75).getBytes());
        this.mPrintStream.write("\r".getBytes());
    }

    public String getUsage() {
        return "backup [directory] [--local] [--allow-leader]";
    }

    public String getDescription() {
        return "backup backs up all Alluxio metadata to the backup directory configured on master. The directory to back up to can be overridden by specifying a directory here. The directory path is relative to the root UFS. To write the backup to the local disk of the primary master, use --local and specify a filesystem path. Backing up metadata will be delegated to standby masters in HA cluster. Use --allow-leader for leader to take the backup when there are no standby masters.(This will pause metadata changes during the backup.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoMoreThan((Command)this, (CommandLine)cl, (int)2);
    }
}

