/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin;

import alluxio.ClientContext;
import alluxio.cli.AbstractShell;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.Context;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.RetryHandlingBlockMasterClient;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.RetryHandlingFileSystemMasterClient;
import alluxio.client.job.JobMasterClient;
import alluxio.client.job.RetryHandlingJobMasterClient;
import alluxio.client.journal.JournalMasterClient;
import alluxio.client.journal.RetryHandlingJournalMasterClient;
import alluxio.client.meta.MetaMasterClient;
import alluxio.client.meta.MetaMasterConfigClient;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.client.metrics.MetricsMasterClient;
import alluxio.client.metrics.RetryHandlingMetricsMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.master.MasterClientContext;
import alluxio.util.ConfigurationUtils;
import alluxio.worker.job.JobMasterClientContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemAdminShell
extends AbstractShell {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemAdminShell.class);

    public FileSystemAdminShell(InstancedConfiguration alluxioConf) {
        super(null, null, alluxioConf);
    }

    public static void main(String[] args) throws IOException {
        int ret;
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        if (!ConfigurationUtils.masterHostConfigured((AlluxioConfiguration)conf) && args.length > 0) {
            System.out.println(ConfigurationUtils.getMasterHostNotConfiguredMessage((String)"Alluxio fsadmin shell"));
            System.exit(1);
        }
        conf.set(PropertyKey.USER_RPC_RETRY_MAX_DURATION, (Object)"5s", Source.DEFAULT);
        try (FileSystemAdminShell fsAdminShell = new FileSystemAdminShell(conf);){
            ret = fsAdminShell.run(args);
        }
        System.exit(ret);
    }

    protected String getShellName() {
        return "fsadmin";
    }

    protected Map<String, Command> loadCommands() {
        ClientContext ctx = ClientContext.create((AlluxioConfiguration)this.mConfiguration);
        MasterClientContext masterConfig = MasterClientContext.newBuilder((ClientContext)ctx).build();
        JobMasterClientContext jobMasterConfig = JobMasterClientContext.newBuilder((ClientContext)ctx).build();
        Context adminContext = new Context((FileSystemMasterClient)new RetryHandlingFileSystemMasterClient(masterConfig), (BlockMasterClient)new RetryHandlingBlockMasterClient(masterConfig), (MetaMasterClient)new RetryHandlingMetaMasterClient(masterConfig), (MetaMasterConfigClient)new RetryHandlingMetaMasterConfigClient(masterConfig), (MetricsMasterClient)new RetryHandlingMetricsMasterClient(masterConfig), (JournalMasterClient)new RetryHandlingJournalMasterClient(masterConfig), (JournalMasterClient)new RetryHandlingJournalMasterClient((MasterClientContext)jobMasterConfig), (JobMasterClient)new RetryHandlingJobMasterClient(jobMasterConfig), System.out);
        return CommandUtils.loadCommands((String)FileSystemAdminShell.class.getPackage().getName(), (Class[])new Class[]{Context.class, AlluxioConfiguration.class}, (Object[])new Object[]{this.mCloser.register((Closeable)adminContext), this.mConfiguration});
    }
}

