/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command.job;

import alluxio.client.job.JobMasterClient;
import alluxio.job.JobConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.retry.RetryPolicy;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobAttempt {
    private static final Logger LOG = LoggerFactory.getLogger(JobAttempt.class);
    protected final JobMasterClient mClient;
    protected final RetryPolicy mRetryPolicy;
    private Long mJobId;
    protected Set<JobInfo> mFailedTasks;
    protected Set<String> mFailedFiles;

    protected JobAttempt(JobMasterClient client, RetryPolicy retryPolicy) {
        this.mClient = client;
        this.mRetryPolicy = retryPolicy;
        this.mFailedFiles = new HashSet<String>();
    }

    public boolean run() {
        while (this.mRetryPolicy.attempt()) {
            this.mJobId = null;
            try {
                this.mJobId = this.mClient.run(this.getJobConfig());
            }
            catch (IOException e) {
                int retryCount = this.mRetryPolicy.getAttemptCount();
                System.out.println(String.format("Retry %d Failed to start job with error: %s", retryCount, e.getMessage()));
                LOG.warn("Retry {} Failed to get status for job (jobId={}) {}", new Object[]{retryCount, this.mJobId, e});
                continue;
            }
            return true;
        }
        this.logFailed();
        return false;
    }

    public Status check() {
        JobInfo jobInfo;
        if (this.mJobId == null) {
            return Status.FAILED;
        }
        try {
            jobInfo = this.mClient.getJobStatusDetailed(this.mJobId.longValue());
        }
        catch (IOException e) {
            LOG.warn("Failed to get status for job (jobId={})", (Object)this.mJobId, (Object)e);
            return Status.FAILED;
        }
        boolean finished = true;
        for (JobInfo child2 : jobInfo.getChildren()) {
            if (child2.getStatus().isFinished()) continue;
            finished = false;
            break;
        }
        if (finished) {
            if (jobInfo.getStatus().equals((Object)Status.FAILED)) {
                this.logFailedAttempt(jobInfo);
                this.mFailedTasks = jobInfo.getChildren().stream().filter(child -> child.getStatus() == Status.FAILED).collect(Collectors.toSet());
                this.setFailedFiles();
            } else if (jobInfo.getStatus().equals((Object)Status.COMPLETED)) {
                this.logCompleted();
            }
            return jobInfo.getStatus();
        }
        return Status.RUNNING;
    }

    public abstract JobConfig getJobConfig();

    public abstract int getSize();

    public Set<String> getFailedFiles() {
        return this.mFailedFiles;
    }

    protected abstract void setFailedFiles();

    protected abstract void logFailedAttempt(JobInfo var1);

    protected abstract void logFailed();

    protected abstract void logCompleted();
}

