/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterInquireClient;
import alluxio.security.user.UserState;
import java.net.InetSocketAddress;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class MasterInfoCommand
extends AbstractFileSystemCommand {
    public MasterInfoCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "masterInfo";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }

    public int run(CommandLine cl) {
        MasterInquireClient inquireClient = MasterInquireClient.Factory.create((AlluxioConfiguration)this.mFsContext.getClusterConf(), (UserState)this.mFsContext.getClientContext().getUserState());
        try {
            InetSocketAddress leaderAddress = inquireClient.getPrimaryRpcAddress();
            System.out.println("Current leader master: " + leaderAddress.toString());
        }
        catch (UnavailableException e) {
            System.out.println("Failed to find leader master");
        }
        try {
            List masterAddresses = inquireClient.getMasterRpcAddresses();
            System.out.println(String.format("All masters: %s", masterAddresses));
        }
        catch (UnavailableException e) {
            System.out.println("Failed to find all master addresses");
        }
        return 0;
    }

    public String getUsage() {
        return "masterInfo";
    }

    public String getDescription() {
        return "Prints information regarding master fault tolerance such as leader address, list of master addresses, and the configured Zookeeper address.";
    }
}

