/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.SecurityUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class LsCommand
extends AbstractFileSystemCommand {
    public static final String IN_ALLUXIO_STATE_DIR = "DIR";
    public static final String IN_ALLUXIO_STATE_FILE_FORMAT = "%d%%";
    public static final String LS_FORMAT_PERMISSION = "%-12s";
    public static final String LS_FORMAT_FILE_SIZE = "%15s";
    public static final String LS_FORMAT_TIMESTAMP = "%24s";
    public static final String LS_FORMAT_ALLUXIO_STATE = "%5s";
    public static final String LS_FORMAT_PERSISTENCE_STATE = "%16s";
    public static final String LS_FORMAT_USER_NAME = "%-15s";
    public static final String LS_FORMAT_GROUP_NAME = "%-15s";
    public static final String LS_FORMAT_FILE_PATH = "%-5s";
    public static final String LS_FORMAT_NO_ACL = "%15s%16s%24s%5s %-5s%n";
    public static final String LS_FORMAT = "%-12s%-15s%-15s%15s%16s%24s%5s %-5s%n";
    private static final Map<String, Comparator<URIStatus>> SORT_FIELD_COMPARATORS = new HashMap<String, Comparator<URIStatus>>();
    private static final Map<String, Function<URIStatus, Long>> TIMESTAMP_FIELDS;
    private static final Option FORCE_OPTION;
    private static final Option LIST_DIR_AS_FILE_OPTION;
    private static final Option LIST_HUMAN_READABLE_OPTION;
    private static final Option LIST_PINNED_FILES_OPTION;
    private static final Option RECURSIVE_OPTION;
    private static final Option SORT_OPTION;
    private static final Option REVERSE_SORT_OPTION;
    private static final Option TIMESTAMP_OPTION;

    public static String formatLsString(boolean hSize, boolean acl, boolean isFolder, String permission, String userName, String groupName, long size, long timestamp, int inAlluxioPercentage, String persistenceState, String path, String dateFormatPattern) {
        String sizeStr;
        String inAlluxioState;
        if (isFolder) {
            inAlluxioState = IN_ALLUXIO_STATE_DIR;
            sizeStr = String.valueOf(size);
        } else {
            inAlluxioState = String.format(IN_ALLUXIO_STATE_FILE_FORMAT, inAlluxioPercentage);
            String string = sizeStr = hSize ? FormatUtils.getSizeFromBytes((long)size) : String.valueOf(size);
        }
        if (acl) {
            return String.format(LS_FORMAT, permission, userName, groupName, sizeStr, persistenceState, CommonUtils.convertMsToDate((long)timestamp, (String)dateFormatPattern), inAlluxioState, path);
        }
        return String.format(LS_FORMAT_NO_ACL, sizeStr, persistenceState, CommonUtils.convertMsToDate((long)timestamp, (String)dateFormatPattern), inAlluxioState, path);
    }

    private void printLsString(URIStatus status, boolean hSize, Function<URIStatus, Long> timestampFunction, boolean pinnedOnly, boolean pinned) {
        if (pinnedOnly && !pinned) {
            return;
        }
        boolean hasExtended = status.getAcl().hasExtended() || !status.getDefaultAcl().isEmpty();
        long timestamp = timestampFunction.apply(status);
        System.out.print(LsCommand.formatLsString(hSize, SecurityUtils.isSecurityEnabled((AlluxioConfiguration)this.mFsContext.getClusterConf()), status.isFolder(), FormatUtils.formatMode((short)((short)status.getMode()), (boolean)status.isFolder(), (boolean)hasExtended), status.getOwner(), status.getGroup(), status.getLength(), timestamp, status.getInAlluxioPercentage(), status.getPersistenceState(), status.getPath(), this.mFsContext.getPathConf(new AlluxioURI(status.getPath())).getString(PropertyKey.USER_DATE_FORMAT_PATTERN)));
    }

    public LsCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "ls";
    }

    public Options getOptions() {
        return new Options().addOption(FORCE_OPTION).addOption(LIST_DIR_AS_FILE_OPTION).addOption(LIST_HUMAN_READABLE_OPTION).addOption(LIST_PINNED_FILES_OPTION).addOption(RECURSIVE_OPTION).addOption(REVERSE_SORT_OPTION).addOption(SORT_OPTION).addOption(TIMESTAMP_OPTION);
    }

    private void ls(AlluxioURI path, boolean recursive, boolean forceLoadMetadata, boolean dirAsFile, boolean hSize, boolean pinnedOnly, String sortField, boolean reverse, String timestampOption) throws AlluxioException, IOException {
        Function<URIStatus, Long> timestampFunction = TIMESTAMP_FIELDS.get(timestampOption);
        if (dirAsFile) {
            URIStatus pathStatus = this.mFileSystem.getStatus(path);
            this.printLsString(pathStatus, hSize, timestampFunction, pinnedOnly, pathStatus.isPinned());
            return;
        }
        ListStatusPOptions.Builder optionsBuilder = ListStatusPOptions.newBuilder();
        if (forceLoadMetadata) {
            optionsBuilder.setLoadMetadataType(LoadMetadataPType.ALWAYS);
        }
        optionsBuilder.setRecursive(recursive);
        if (sortField == null) {
            this.mFileSystem.iterateStatus(path, optionsBuilder.build(), status -> this.printLsString((URIStatus)status, hSize, timestampFunction, pinnedOnly, status.isPinned()));
            return;
        }
        List statusList = this.mFileSystem.listStatus(path, optionsBuilder.build());
        List<URIStatus> sorted = this.sortByFieldAndOrder(statusList, sortField, reverse);
        for (URIStatus status2 : sorted) {
            this.printLsString(status2, hSize, timestampFunction, pinnedOnly, status2.isPinned());
        }
    }

    private List<URIStatus> sortByFieldAndOrder(List<URIStatus> statuses, String sortField, boolean reverse) throws IOException {
        Optional<Comparator<URIStatus>> sortToUse = Optional.ofNullable(SORT_FIELD_COMPARATORS.get(sortField));
        if (!sortToUse.isPresent()) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_SORT_FIELD.getMessage(new Object[]{sortField}));
        }
        Comparator<URIStatus> sortBy = sortToUse.get();
        if (reverse) {
            sortBy = sortBy.reversed();
        }
        return statuses.stream().sorted(sortBy).collect(Collectors.toList());
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        this.ls(path, cl.hasOption(RECURSIVE_OPTION.getOpt()), cl.hasOption("f"), cl.hasOption("d"), cl.hasOption("h"), cl.hasOption("p"), cl.getOptionValue("sort", null), cl.hasOption("r"), cl.getOptionValue("timestamp", "lastModificationTime"));
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args;
        for (String dirArg : args = cl.getArgs()) {
            AlluxioURI path = new AlluxioURI(dirArg);
            this.runWildCardCmd(path, cl);
        }
        return 0;
    }

    public String getUsage() {
        return "ls [-d|-f|-p|-R/--recursive|-h|--sort=option|--timestamp=option|-r] <path> ...";
    }

    public String getDescription() {
        return "Displays information for all files and directories directly under the specified paths, including permission, owner, group, size (bytes for files or the number of children for directories, persistence state, last modified time, the percentage of content already in Alluxio and the path in order.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
        String timestampOption = cl.getOptionValue("timestamp");
        if (timestampOption != null && !TIMESTAMP_FIELDS.containsKey(timestampOption)) {
            throw new InvalidArgumentException(String.format("Unrecognized timestamp option %s", timestampOption));
        }
    }

    static {
        SORT_FIELD_COMPARATORS.put("creationTime", Comparator.comparingLong(URIStatus::getCreationTimeMs));
        SORT_FIELD_COMPARATORS.put("inMemoryPercentage", Comparator.comparingLong(URIStatus::getInMemoryPercentage));
        SORT_FIELD_COMPARATORS.put("lastAccessTime", Comparator.comparingLong(URIStatus::getLastAccessTimeMs));
        SORT_FIELD_COMPARATORS.put("lastModificationTime", Comparator.comparingLong(URIStatus::getLastModificationTimeMs));
        SORT_FIELD_COMPARATORS.put("name", Comparator.comparing(URIStatus::getName, String.CASE_INSENSITIVE_ORDER));
        SORT_FIELD_COMPARATORS.put("path", Comparator.comparing(URIStatus::getPath));
        SORT_FIELD_COMPARATORS.put("size", Comparator.comparingLong(URIStatus::getLength));
        TIMESTAMP_FIELDS = new HashMap<String, Function<URIStatus, Long>>();
        TIMESTAMP_FIELDS.put("creationTime", URIStatus::getCreationTimeMs);
        TIMESTAMP_FIELDS.put("lastAccessTime", URIStatus::getLastAccessTimeMs);
        TIMESTAMP_FIELDS.put("lastModificationTime", URIStatus::getLastModificationTimeMs);
        FORCE_OPTION = Option.builder((String)"f").required(false).hasArg(false).desc("force to load metadata for immediate children in a directory").build();
        LIST_DIR_AS_FILE_OPTION = Option.builder((String)"d").required(false).hasArg(false).desc("list directories as plain files").build();
        LIST_HUMAN_READABLE_OPTION = Option.builder((String)"h").required(false).hasArg(false).desc("print human-readable format sizes").build();
        LIST_PINNED_FILES_OPTION = Option.builder((String)"p").required(false).hasArg(false).desc("list all pinned files").build();
        RECURSIVE_OPTION = Option.builder((String)"R").longOpt("recursive").required(false).hasArg(false).desc("list subdirectories recursively").build();
        SORT_OPTION = Option.builder().required(false).longOpt("sort").hasArg(true).desc("sort statuses by the given field {" + String.join((CharSequence)"|", SORT_FIELD_COMPARATORS.keySet()) + "}").build();
        REVERSE_SORT_OPTION = Option.builder((String)"r").required(false).hasArg(false).desc("reverse order while sorting").build();
        TIMESTAMP_OPTION = Option.builder().required(false).longOpt("timestamp").hasArg(true).desc("display specific timestamp(default is last modification time) {" + String.join((CharSequence)"|", TIMESTAMP_FIELDS.keySet()) + "}").build();
    }
}

