/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.wire.BlockLocation;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class LocationCommand
extends AbstractFileSystemCommand {
    public LocationCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "location";
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        URIStatus status = this.mFileSystem.getStatus(plainPath);
        System.out.println(plainPath + " with file id " + status.getFileId() + " is on nodes: ");
        BlockStoreClient blockStore = BlockStoreClient.create((FileSystemContext)this.mFsContext);
        Iterator iterator = status.getBlockIds().iterator();
        while (iterator.hasNext()) {
            long blockId = (Long)iterator.next();
            for (BlockLocation location : blockStore.getInfo(blockId).getLocations()) {
                System.out.println(location.getWorkerAddress().getHost());
            }
        }
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "location <path>";
    }

    public String getDescription() {
        return "Displays the list of hosts storing the specified file.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }
}

