/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.InStreamOptions;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.CacheRequest;
import alluxio.grpc.OpenFilePOptions;
import alluxio.proto.dataserver.Protocol;
import alluxio.resource.CloseableResource;
import alluxio.util.FileSystemOptions;
import alluxio.wire.BlockInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class LoadCommand
extends AbstractFileSystemCommand {
    private static final Option LOCAL_OPTION = Option.builder().longOpt("local").required(false).hasArg(false).desc("load the file to local worker.").build();

    public LoadCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "load";
    }

    public Options getOptions() {
        return new Options().addOption(LOCAL_OPTION);
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        this.load(plainPath, cl.hasOption(LOCAL_OPTION.getLongOpt()));
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    private void load(AlluxioURI filePath, boolean local) throws AlluxioException, IOException {
        URIStatus status = this.mFileSystem.getStatus(filePath);
        if (status.isFolder()) {
            List statuses = this.mFileSystem.listStatus(filePath);
            for (URIStatus uriStatus : statuses) {
                AlluxioURI newPath = new AlluxioURI(uriStatus.getPath());
                this.load(newPath, local);
            }
        } else {
            if (local) {
                if (!this.mFsContext.hasNodeLocalWorker()) {
                    System.out.println("When local option is specified, there must be a local worker available");
                    return;
                }
            } else if (status.getInAlluxioPercentage() == 100) {
                System.out.println(filePath + " already in Alluxio fully");
                return;
            }
            this.runLoadTask(filePath, status, local);
        }
        System.out.println(filePath + " loaded");
    }

    private void runLoadTask(AlluxioURI filePath, URIStatus status, boolean local) throws IOException {
        AlluxioConfiguration conf = this.mFsContext.getPathConf(filePath);
        OpenFilePOptions options = FileSystemOptions.openFileDefaults((AlluxioConfiguration)conf);
        BlockLocationPolicy policy = (BlockLocationPolicy)Preconditions.checkNotNull((Object)BlockLocationPolicy.Factory.create((Class)conf.getClass(PropertyKey.USER_UFS_BLOCK_READ_LOCATION_POLICY), (AlluxioConfiguration)conf), (Object)"UFS read location policy Required when loading files");
        List blockIds = status.getBlockIds();
        Iterator iterator = blockIds.iterator();
        while (iterator.hasNext()) {
            WorkerNetAddress dataSource;
            long blockId = (Long)iterator.next();
            if (local) {
                dataSource = this.mFsContext.getNodeLocalWorker();
            } else {
                BlockStoreClient blockStore = BlockStoreClient.create((FileSystemContext)this.mFsContext);
                Pair dataSourceAndType = blockStore.getDataSourceAndType(status.getBlockInfo(blockId), status, policy, (Map)ImmutableMap.of());
                dataSource = (WorkerNetAddress)dataSourceAndType.getFirst();
            }
            Protocol.OpenUfsBlockOptions openUfsBlockOptions = new InStreamOptions(status, options, conf).getOpenUfsBlockOptions(blockId);
            this.cacheBlock(blockId, dataSource, status, openUfsBlockOptions);
        }
    }

    public String getUsage() {
        return "load [--local] <path>";
    }

    public String getDescription() {
        return "Loads a file or directory in Alluxio space, makes it resident in Alluxio.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }

    private void cacheBlock(long blockId, WorkerNetAddress dataSource, URIStatus status, Protocol.OpenUfsBlockOptions options) {
        BlockInfo info = status.getBlockInfo(blockId);
        long blockLength = info.getLength();
        String host = dataSource.getHost();
        if (!dataSource.getContainerHost().equals("")) {
            host = dataSource.getContainerHost();
        }
        CacheRequest request = CacheRequest.newBuilder().setBlockId(blockId).setLength(blockLength).setOpenUfsBlockOptions(options).setSourceHost(host).setSourcePort(dataSource.getDataPort()).build();
        try (CloseableResource blockWorker = this.mFsContext.acquireBlockWorkerClient(dataSource);){
            ((BlockWorkerClient)blockWorker.get()).cache(request);
        }
        catch (Exception e) {
            System.out.printf("Failed to complete cache request for block %d of file %s: %s", blockId, status.getPath(), e);
        }
    }
}

