/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.FormatUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class HeadCommand
extends AbstractFileSystemCommand {
    private static final Option BYTES_OPTION = Option.builder((String)"c").required(false).numberOfArgs(1).desc("number of bytes (e.g., 1024, 4KB)").build();
    private int mNumOfBytes;

    public HeadCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "head";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        URIStatus status = this.mFileSystem.getStatus(plainPath);
        if (status.isFolder()) {
            throw new IOException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{plainPath}));
        }
        try (FileInStream is = this.mFileSystem.openFile(plainPath);){
            long bytesToRead = status.getLength() > (long)this.mNumOfBytes ? (long)this.mNumOfBytes : status.getLength();
            byte[] buf = new byte[(int)bytesToRead];
            int read = is.read(buf);
            if (read != -1) {
                System.out.write(buf, 0, read);
            }
        }
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        this.mNumOfBytes = 1024;
        if (cl.hasOption('c')) {
            this.mNumOfBytes = (int)FormatUtils.parseSpaceSize((String)cl.getOptionValue('c'));
            Preconditions.checkArgument((this.mNumOfBytes > 0 ? 1 : 0) != 0, (Object)"specified bytes must be > 0");
        }
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "head [-c <bytes>] <path>";
    }

    public String getDescription() {
        return "Prints the file's first n bytes (by default, 1KB) to the console.";
    }

    public Options getOptions() {
        return new Options().addOption(BYTES_OPTION);
    }
}

