/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.wire.SyncPointInfo;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class GetSyncPathListCommand
extends AbstractFileSystemCommand {
    public GetSyncPathListCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "getSyncPathList";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        List files = this.mFileSystem.getSyncPathList();
        System.out.println("The following paths are under active sync");
        block5: for (SyncPointInfo syncPointInfo : files) {
            System.out.print(syncPointInfo.getSyncPointUri() + "\t");
            switch (syncPointInfo.getSyncStatus()) {
                case NOT_INITIALLY_SYNCED: {
                    System.out.println("Initial Sync Skipped");
                    continue block5;
                }
                case INITIALLY_SYNCED: {
                    System.out.println("Initial Sync Done");
                    continue block5;
                }
                case SYNCING: {
                    System.out.println("Initial Sync In Progress");
                    continue block5;
                }
            }
            System.out.println("Invalid Syncing Status");
        }
        return 0;
    }

    public String getUsage() {
        return "getSyncPathList";
    }

    public String getDescription() {
        return "Gets all the paths that are under active syncing right now.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)0);
    }
}

