/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.ListStatusPOptions;
import alluxio.util.FormatUtils;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class DuCommand
extends AbstractFileSystemCommand {
    private static final String GROUPED_MEMORY_OPTION_FORMAT = "%-13s %-16s %-16s %-25s %s";
    private static final String MEMORY_OPTION_FORMAT = "%-13s %-16s %-16s %s";
    private static final String GROUPED_OPTION_FORMAT = "%-13s %-16s %-25s %s";
    private static final String SHORT_INFO_FORMAT = "%-13s %-16s %s";
    private static final String VALUE_AND_PERCENT_FORMAT = "%s (%d%%)";
    private static final String MEMORY_OPTION_NAME = "m";
    private static final String MEMORY_OPTION_LONG_NAME = "memory";
    private static final String READABLE_OPTION_NAME = "h";
    private static final String SUMMARIZE_OPTION_NAME = "s";
    private static final String GROUP_BY_WORKER_OPTION_NAME = "g";
    private static final Option MEMORY_OPTION = Option.builder((String)"m").longOpt("memory").required(false).hasArg(false).desc("display the in memory size and in memory percentage").build();
    private static final Option READABLE_OPTION = Option.builder((String)"h").required(false).hasArg(false).desc("print sizes in human readable format (e.g., 1KB 234MB 2GB)").build();
    private static final Option SUMMARIZE_OPTION = Option.builder((String)"s").required(false).hasArg(false).desc("display the aggregate summary of file lengths being displayed").build();
    private static final Option GROUP_BY_WORKER_OPTION = Option.builder((String)"g").required(false).hasArg(false).desc("display information for In-Alluxio data size under the path, grouped by worker.").build();

    public DuCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "du";
    }

    @Override
    protected void processHeader(CommandLine cl) {
        DuCommand.printInfo("File Size", "In Alluxio", "Path", cl.hasOption(MEMORY_OPTION_NAME) ? Optional.of("In Memory") : Optional.empty(), cl.hasOption(GROUP_BY_WORKER_OPTION_NAME) ? Optional.of("Worker Host Name") : Optional.empty());
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        Optional<String> workerHostName;
        ListStatusPOptions listOptions = ListStatusPOptions.newBuilder().setRecursive(true).build();
        boolean readable = cl.hasOption(READABLE_OPTION_NAME);
        boolean groupByWorker = cl.hasOption(GROUP_BY_WORKER_OPTION_NAME);
        boolean addMemory = cl.hasOption(MEMORY_OPTION_NAME);
        Optional<String> optional = workerHostName = groupByWorker ? Optional.of("total") : Optional.empty();
        if (cl.hasOption(SUMMARIZE_OPTION_NAME)) {
            AtomicLong totalSize = new AtomicLong();
            AtomicLong sizeInAlluxio = new AtomicLong();
            AtomicLong sizeInMem = new AtomicLong();
            HashMap<String, Long> distributionMap = new HashMap<String, Long>();
            this.mFileSystem.iterateStatus(path, listOptions, status -> {
                if (!status.isFolder()) {
                    long size = status.getLength();
                    totalSize.addAndGet(size);
                    sizeInMem.addAndGet(size * (long)status.getInMemoryPercentage());
                    sizeInAlluxio.addAndGet(size * (long)status.getInAlluxioPercentage());
                }
                if (groupByWorker) {
                    DuCommand.fillDistributionMap(distributionMap, status);
                }
            });
            String sizeMessage = readable ? FormatUtils.getSizeFromBytes((long)totalSize.get()) : String.valueOf(totalSize);
            String inAlluxioMessage = DuCommand.getFormattedValues(readable, sizeInAlluxio.get() / 100L, totalSize.get());
            Optional<String> inMemMessage = addMemory ? Optional.of(DuCommand.getFormattedValues(readable, sizeInMem.get() / 100L, totalSize.get())) : Optional.empty();
            DuCommand.printInfo(sizeMessage, inAlluxioMessage, path.toString(), inMemMessage, workerHostName);
            Optional<String> inMem = inMemMessage.isPresent() ? Optional.of("") : inMemMessage;
            DuCommand.getSizeInfoGroupByWorker(distributionMap, readable, inMem);
        } else {
            List statuses = this.mFileSystem.listStatus(path, listOptions);
            if (statuses == null || statuses.size() == 0) {
                return;
            }
            statuses.sort(Comparator.comparing(URIStatus::getPath));
            for (URIStatus status2 : statuses) {
                if (status2.isFolder()) continue;
                long totalSize = status2.getLength();
                String sizeMessage = readable ? FormatUtils.getSizeFromBytes((long)totalSize) : String.valueOf(totalSize);
                String inAlluxioMessage = DuCommand.getFormattedValues(readable, (long)status2.getInAlluxioPercentage() * totalSize / 100L, totalSize);
                Optional<String> inMemMessage = addMemory ? Optional.of(DuCommand.getFormattedValues(readable, (long)status2.getInMemoryPercentage() * totalSize / 100L, totalSize)) : Optional.empty();
                HashMap<String, Long> distributionMap = new HashMap<String, Long>();
                if (groupByWorker) {
                    DuCommand.fillDistributionMap(distributionMap, status2);
                }
                Optional<String> inMem = inMemMessage.isPresent() ? Optional.of("") : inMemMessage;
                DuCommand.printInfo(sizeMessage, inAlluxioMessage, status2.getPath(), inMemMessage, workerHostName);
                DuCommand.getSizeInfoGroupByWorker(distributionMap, readable, inMem);
            }
        }
    }

    private static void fillDistributionMap(Map<String, Long> distributionMap, URIStatus status) {
        for (FileBlockInfo fileBlockInfo : status.getFileBlockInfos()) {
            long length = fileBlockInfo.getBlockInfo().getLength();
            for (BlockLocation blockLocation : fileBlockInfo.getBlockInfo().getLocations()) {
                distributionMap.compute(blockLocation.getWorkerAddress().getHost(), (hostName, totalLength) -> totalLength == null ? length : totalLength + length);
            }
        }
    }

    private static void getSizeInfoGroupByWorker(Map<String, Long> distributionMap, boolean readable, Optional<String> inMem) {
        distributionMap.forEach((hostName, size) -> {
            String inAlluxioMessageThisWorker = readable ? FormatUtils.getSizeFromBytes((long)size) : String.valueOf(size);
            DuCommand.printInfo("", inAlluxioMessageThisWorker, "", inMem, Optional.of(hostName));
        });
    }

    private static String getFormattedValues(boolean readable, long size, long totalSize) {
        int percent = totalSize == 0L ? 0 : (int)(size * 100L / totalSize);
        String subSizeMessage = readable ? FormatUtils.getSizeFromBytes((long)size) : String.valueOf(size);
        return String.format(VALUE_AND_PERCENT_FORMAT, subSizeMessage, percent);
    }

    private static void printInfo(String sizeMessage, String inAlluxioMessage, String path, Optional<String> inMemMessage, Optional<String> workerHostName) {
        String message = inMemMessage.isPresent() && workerHostName.isPresent() ? String.format(GROUPED_MEMORY_OPTION_FORMAT, sizeMessage, inAlluxioMessage, inMemMessage.get(), workerHostName.get(), path) : (inMemMessage.isPresent() ? String.format(MEMORY_OPTION_FORMAT, sizeMessage, inAlluxioMessage, inMemMessage.get(), path) : (workerHostName.isPresent() ? String.format(GROUPED_OPTION_FORMAT, sizeMessage, inAlluxioMessage, workerHostName.get(), path) : String.format(SHORT_INFO_FORMAT, sizeMessage, inAlluxioMessage, path)));
        System.out.println(message);
    }

    public String getUsage() {
        return "du [-h|-s|-g|-m] <path>";
    }

    public String getDescription() {
        return "Displays the total size and the in Alluxio size of the specified file or directory.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public Options getOptions() {
        return new Options().addOption(GROUP_BY_WORKER_OPTION).addOption(MEMORY_OPTION).addOption(READABLE_OPTION).addOption(SUMMARIZE_OPTION);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }
}

